"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStickyAutocompleteExtensions = exports.useNoLintExtensions = exports.useLintExtensions = exports.useAutocompleteExtensions = exports.tabKeyExtensions = exports.syntaxCSS = exports.resetColors = exports.readableExtensions = exports.readOnlyNoCursorExtensions = exports.readOnlyExtensions = exports.lineWrappingExtensions = exports.historyExtensions = exports.getTooltipAbsoluteExtensions = exports.getThemeExtensions = exports.getTabKeyExtensions = exports.getSearchExtensions = exports.getReadableExtensions = exports.getReadOnlyExtensions = exports.getPlaceholderExtensions = exports.getLintExtensions = exports.getLineWrappingExtensions = exports.getLineNumbersExtensions = exports.getHistoryExtensions = exports.getCypherLanguageExtensions = exports.getCursorWideExtensions = exports.getCloseBracketsExtensions = exports.getBracketMatchingExtensions = exports.getAutocompleteExtensions = exports.fixColors = exports.domListener = exports.cypherLinter = exports.cypherLineNumbers = exports.cypherLanguage = exports.cypherCompletion = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _autocomplete = require("@codemirror/autocomplete");
var _commands = require("@codemirror/commands");
var _language = require("@codemirror/language");
var _lint = require("@codemirror/lint");
var _search = require("@codemirror/search");
var _state = require("@codemirror/state");
var _view = require("@codemirror/view");
var _highlight = require("@lezer/highlight");
var _editorSupport = require("@neo4j-cypher/editor-support");
var _cypherCodemirrorBase = require("./cypher-codemirror-base");
var _cypher = require("./cypher");
var _cypherStateDefinitions = require("./cypher-state-definitions");
var _cypherStateSelectors = require("./cypher-state-selectors");
const _excluded = ["delay", "showErrors"];
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
const typeMarkerTheme = _view.EditorView.baseTheme({
  // ".cm-underline": { textDecoration: "underline 3px red" }
});
const typeMarkerFromTo = (view, options = {}) => {
  const effects = [_cypherStateDefinitions.addTypeMarkerEffect.of(options)];
  view.dispatch({
    effects
  });
  return true;
};
const resetColors = (view, editorSupport) => {
  const effects = [_cypherStateDefinitions.clearTypeMarkersEffect.of()];
  view.dispatch({
    effects
  });
};
exports.resetColors = resetColors;
const fixColors = (view, editorSupport) => {
  resetColors(view, editorSupport);
  if (!editorSupport.parseTree || !editorSupport.input) {
    return;
  }
  editorSupport.applyHighlighthing((element, type) => {
    const {
      start: from,
      stop: to
    } = _editorSupport.TreeUtils.getPosition(element) || {
      start: 0,
      stop: 0
    };
    typeMarkerFromTo(view, {
      from,
      to: to + 1,
      type
    });
  });
};
exports.fixColors = fixColors;
const domListener = ({
  onFocusChanged = () => {},
  onScrollChanged = () => {},
  onKeyDown = () => {},
  onKeyUp = () => {}
}) => [_view.EditorView.domEventHandlers({
  focus: () => {
    onFocusChanged(true);
  },
  blur: () => {
    onFocusChanged(false);
  },
  scroll: (event, view) => {
    if (event.target === view.scrollDOM) {
      const {
        scrollTop,
        clientHeight,
        scrollHeight,
        scrollLeft,
        clientWidth,
        scrollWidth
      } = event.target;
      onScrollChanged({
        scrollTop,
        clientHeight,
        scrollHeight,
        scrollLeft,
        clientWidth,
        scrollWidth
      });
    }
  },
  keydown: event => {
    onKeyDown(event);
  },
  keyup: event => {
    onKeyUp(event);
  }
})];
exports.domListener = domListener;
const cypherLinter = (_ref = {}) => {
  let {
      delay = 750,
      showErrors = true
    } = _ref,
    otherOptions = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  return [(0, _lint.linter)(view => {
    // Empty editor, no need to lint
    if (!(0, _cypherStateSelectors.getStateValue)(view.state).length) return [];
    const editorSupport = (0, _cypherStateSelectors.getStateEditorSupport)(view.state);
    if (!editorSupport) return [];
    const version = view.newContentVersion();
    editorSupport.update((0, _cypherStateSelectors.getStateValue)(view.state), version);
    fixColors(view, editorSupport);
    return (showErrors && editorSupport.parseErrors || []).map(({
      msg,
      start,
      stop
    }) => {
      return {
        severity: "error",
        from: start,
        to: stop + 1,
        message: msg
      };
    });
  }, _objectSpread(_objectSpread({}, otherOptions), {}, {
    delay
  }))];
};
exports.cypherLinter = cypherLinter;
const cypherLanguage = () => [_language.StreamLanguage.define(_cypher.cypher)];
exports.cypherLanguage = cypherLanguage;
const cypherCompletions = context => {
  const editorSupport = (0, _cypherStateSelectors.getStateEditorSupport)(context.state);
  editorSupport.update((0, _cypherStateSelectors.getStateValue)(context.state));
  const {
    line,
    column
  } = editorSupport.positionConverter.toRelative(context.pos);
  const completion = editorSupport.getCompletion(line, column, true);
  const {
    items,
    from,
    to
  } = completion;
  const completions = items.map(({
    type,
    view,
    content,
    postfix
  }) => ({
    type,
    label: view,
    apply: content,
    detail: postfix
  }));
  let word = context.matchBefore(/\w*/);
  let cypherCompletions = null;
  if (!(word.from == word.to && !context.explicit)) {
    cypherCompletions = {
      //from: word.from,
      // TODO - line is 1 based, column is 0 based
      from: (0, _cypherStateSelectors.getStatePositionAbsoluteForLineColumn)(context.state, from),
      options: completions,
      filter: false,
      getMatch: () => []
    };
  }
  return cypherCompletions;
};
const cypherCompletion = ({
  activateOnTyping = false /* Could be made an option... */,
  closeOnBlur = true
} = {}) => [(0, _autocomplete.autocompletion)({
  activateOnTyping,
  closeOnBlur,
  override: [cypherCompletions]
})];
exports.cypherCompletion = cypherCompletion;
const syntaxStyles = [{
  tag: _highlight.tags.comment,
  class: "cm-comment"
}, {
  tag: _highlight.tags.variableName,
  class: "cm-variable"
}, {
  tag: [_highlight.tags.string, _highlight.tags.special(_highlight.tags.brace)],
  class: "cm-string"
}, {
  tag: _highlight.tags.number,
  class: "cm-number"
}, {
  tag: _highlight.tags.keyword,
  class: "cm-keyword"
}, {
  tag: _highlight.tags.operator,
  class: "cm-operator"
}];
const syntaxStyle = _language.HighlightStyle.define(syntaxStyles);
const syntaxCSS = [(0, _language.syntaxHighlighting)(syntaxStyle)];
exports.syntaxCSS = syntaxCSS;
const cypherLineNumbers = ({
  lineNumberFormatter,
  onLineNumberClick = () => {}
}) => [(0, _view.lineNumbers)({
  formatNumber: (number, state) => lineNumberFormatter(number, (0, _cypherStateSelectors.getStateLineCount)(state), state),
  domEventHandlers: {
    click(view, lineObject, event) {
      const {
        line
      } = (0, _cypherStateSelectors.getStatePositionForAbsolute)(view.state, lineObject.from) || {};
      onLineNumberClick(line, event);
      return true;
    }
  }
})];

// EXTENSIONS COLLECTIONS
exports.cypherLineNumbers = cypherLineNumbers;
const themeOverrides = {
  "&.cm-editor": {
    "&.cm-focused": {
      outline: "none"
    }
  },
  ".cm-content": {
    fontFamily: "Fira Code, Menlo, Monaco, Lucida Console, monospace"
  },
  ".cm-cursor .cm-cursor-wide": {
    borderLeft: "0.67em solid rgba(147, 161, 161, 0.37)"
  }
};
const USE_DARK_FLAG = true;
const themeDarkExtensions = [_view.EditorView.theme(themeOverrides, USE_DARK_FLAG ? {
  dark: true
} : {}), _view.EditorView.editorAttributes.of({
  class: "cm-dark"
})];
const themeLightExtensions = [_view.EditorView.theme(themeOverrides, USE_DARK_FLAG ? {
  dark: false
} : {}), _view.EditorView.editorAttributes.of({
  class: "cm-light"
})];
const themeAutoExtensions = [_view.EditorView.theme(themeOverrides, {}), _view.EditorView.editorAttributes.of({
  class: "cm-auto"
})];
const cursorWideExtensions = [_view.EditorView.editorAttributes.of({
  class: "cm-cursor-wide"
})];
const cursorNormalExtensions = [_view.EditorView.editorAttributes.of({
  class: "cm-cursor-normal"
})];
const runTab = view => {
  const {
    state,
    dispatch
  } = view;
  const status = (0, _autocomplete.completionStatus)(state);
  if (status === null) {
    if ((0, _cypherStateSelectors.getStateHasSelection)(state)) {
      return (0, _commands.indentMore)(view);
    } else {
      dispatch(state.update(state.replaceSelection(state.facet(_language.indentUnit)), {
        scrollIntoView: true,
        userEvent: "input"
      }));
      return true;
    }
  } else if (status === "active") {
    return (0, _autocomplete.acceptCompletion)(view);
  }
  return false;
};
const shiftTab = view => {
  const {
    state
  } = view;
  const status = (0, _autocomplete.completionStatus)(state);
  if (status === null && (0, _cypherStateSelectors.getStateHasSelection)(state)) {
    return (0, _commands.indentLess)(view);
  }
  return false;
};
const tabKeyExtensions = [_view.keymap.of([{
  key: "Tab",
  run: runTab,
  shift: shiftTab
}])];
exports.tabKeyExtensions = tabKeyExtensions;
const historyExtensions = [(0, _commands.history)(), _view.keymap.of(_commands.historyKeymap)];
exports.historyExtensions = historyExtensions;
const searchTopExtensions = [(0, _search.search)({
  top: true
}), _view.keymap.of(_search.searchKeymap)];
const searchBottomExtensions = [(0, _search.search)({
  top: false
}), _view.keymap.of(_search.searchKeymap)];
const readableExtensions = [(0, _view.drawSelection)(), _state.EditorState.allowMultipleSelections.of(true), (0, _language.indentOnInput)(), (0, _view.rectangularSelection)(), (0, _view.crosshairCursor)(), _view.keymap.of([..._commands.defaultKeymap, ..._language.foldKeymap])];
exports.readableExtensions = readableExtensions;
const readOnlyExtensions = [_state.EditorState.readOnly.of(true)];
exports.readOnlyExtensions = readOnlyExtensions;
const readOnlyNoCursorExtensions = [_state.EditorState.readOnly.of(true), _view.EditorView.editable.of(false)];
exports.readOnlyNoCursorExtensions = readOnlyNoCursorExtensions;
const lineWrappingExtensions = [_view.EditorView.lineWrapping];
exports.lineWrappingExtensions = lineWrappingExtensions;
const useLintExtensions = [cypherLinter(), _view.keymap.of(_lint.lintKeymap)];
exports.useLintExtensions = useLintExtensions;
const useNoLintExtensions = [cypherLinter({
  showErrors: false
})];
exports.useNoLintExtensions = useNoLintExtensions;
const useAutocompleteExtensions = [cypherCompletion(), _view.keymap.of(_autocomplete.completionKeymap)];
exports.useAutocompleteExtensions = useAutocompleteExtensions;
const useStickyAutocompleteExtensions = [cypherCompletion({
  closeOnBlur: false
}), _view.keymap.of(_autocomplete.completionKeymap)];

// GETTERS
exports.useStickyAutocompleteExtensions = useStickyAutocompleteExtensions;
const getCypherLanguageExtensions = ({
  cypherLanguage: cypher
}) => cypher ? [cypherLanguage(), _cypherStateDefinitions.typeMarkerField, typeMarkerTheme, _cypherStateDefinitions.editorSupportField, syntaxCSS, _view.EditorView.editorAttributes.of({
  class: "cm-cypher"
})] : [];
exports.getCypherLanguageExtensions = getCypherLanguageExtensions;
const getAutocompleteExtensions = ({
  cypherLanguage,
  readOnly,
  autocomplete,
  autocompleteCloseOnBlur
}) => cypherLanguage && readOnly === false && autocomplete ? !autocompleteCloseOnBlur ? useStickyAutocompleteExtensions : useAutocompleteExtensions : [];
exports.getAutocompleteExtensions = getAutocompleteExtensions;
const getCursorWideExtensions = ({
  cursorWide
}) => cursorWide ? cursorWideExtensions : cursorNormalExtensions;
exports.getCursorWideExtensions = getCursorWideExtensions;
const getHistoryExtensions = ({
  history
}) => history ? historyExtensions : [];
exports.getHistoryExtensions = getHistoryExtensions;
const getLineNumbersExtensions = ({
  lineNumbers,
  lineNumberFormatter,
  onLineNumberClick
}) => lineNumbers ? [cypherLineNumbers({
  lineNumberFormatter,
  onLineNumberClick
})] : [];
exports.getLineNumbersExtensions = getLineNumbersExtensions;
const getLineWrappingExtensions = ({
  lineWrapping
}) => lineWrapping ? lineWrappingExtensions : [];
exports.getLineWrappingExtensions = getLineWrappingExtensions;
const getLintExtensions = ({
  cypherLanguage,
  readOnly,
  lint
}) => cypherLanguage && readOnly === false && lint ? useLintExtensions : useNoLintExtensions;
exports.getLintExtensions = getLintExtensions;
const getPlaceholderExtensions = ({
  placeholder
}) => placeholder !== undefined ? [(0, _view.placeholder)(placeholder)] : [];
exports.getPlaceholderExtensions = getPlaceholderExtensions;
const getReadableExtensions = ({
  readOnly,
  readOnlyCursor
}) => !readOnly || readOnlyCursor ? readableExtensions : [];
exports.getReadableExtensions = getReadableExtensions;
const getReadOnlyExtensions = ({
  readOnly,
  readOnlyCursor
}) => readOnly ? readOnlyCursor ? readOnlyExtensions : readOnlyNoCursorExtensions : [];
exports.getReadOnlyExtensions = getReadOnlyExtensions;
const getTabKeyExtensions = ({
  tabKey,
  indentUnit
}) => tabKey ? tabKeyExtensions.concat(_language.indentUnit.of(indentUnit)) : [];
exports.getTabKeyExtensions = getTabKeyExtensions;
const getThemeExtensions = ({
  theme
}) => theme === _cypherCodemirrorBase.THEME_DARK ? themeDarkExtensions : theme === _cypherCodemirrorBase.THEME_AUTO ? themeAutoExtensions : themeLightExtensions;
exports.getThemeExtensions = getThemeExtensions;
const getSearchExtensions = ({
  readOnly,
  search,
  searchTop
}) => search ? searchTop ? searchTopExtensions : searchBottomExtensions : [];
exports.getSearchExtensions = getSearchExtensions;
const getTooltipAbsoluteExtensions = ({
  tooltipAbsolute
}) => tooltipAbsolute ? [(0, _view.tooltips)({
  position: "absolute"
})] : [(0, _view.tooltips)({
  position: "fixed"
})];
exports.getTooltipAbsoluteExtensions = getTooltipAbsoluteExtensions;
const getCloseBracketsExtensions = ({
  closeBrackets
}) => closeBrackets ? [(0, _autocomplete.closeBrackets)(), _view.keymap.of(_autocomplete.closeBracketsKeymap)] : [];
exports.getCloseBracketsExtensions = getCloseBracketsExtensions;
const getBracketMatchingExtensions = ({
  bracketMatching
}) => bracketMatching ? [(0, _language.bracketMatching)()] : [];
exports.getBracketMatchingExtensions = getBracketMatchingExtensions;