"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.searchStateField = exports.getViewUpdatePickedAutocompleteOption = exports.getViewUpdateAnnotationValueForType = exports.getStateValue = exports.getStateSelection = exports.getStateSearchText = exports.getStateSearchSpec = exports.getStateSearchOpen = exports.getStateSearchMatches = exports.getStatePositionForAny = exports.getStatePositionForAbsolute = exports.getStatePositionAnchorAbsolute = exports.getStatePositionAnchor = exports.getStatePositionAbsoluteForLineColumn = exports.getStatePositionAbsolute = exports.getStatePosition = exports.getStateLineObjectForLine = exports.getStateLineObjectForAbsolute = exports.getStateLineCount = exports.getStateLength = exports.getStateHasSelection = exports.getStateEditorSupport = exports.getStateAutocompleteOptions = exports.getStateAutocompleteOpen = exports.getSearchState = exports.getFormattedAutocompleteOption = exports.getAutocompleteState = exports.autocompletionStateField = exports.areViewUpdateAutocompleteOptionsEqual = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _search = require("@codemirror/search");
var _autocomplete = require("@codemirror/autocomplete");
var _state = require("@codemirror/state");
var _cypherCodemirrorBase = require("./cypher-codemirror-base");
var _cypherStateDefinitions = require("./cypher-state-definitions");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
const getStateField = (mainExtension, label) => {
  const extensions = mainExtension();
  if (Array.isArray(extensions)) {
    const stateField = extensions.find(ex => ex instanceof _state.StateField);
    if (stateField) {
      return stateField;
    }
  }
  const length = Array.isArray(extensions) ? extensions.length : "no";
  throw new Error("getStateField for " + label + " failed (" + length + " extensions found)");
};
const searchStateField = getStateField(_search.search, "search");
exports.searchStateField = searchStateField;
const autocompletionStateField = getStateField(_autocomplete.autocompletion, "autocompletion");
exports.autocompletionStateField = autocompletionStateField;
const getStatePositionAnchorAbsolute = state => state.selection.main.anchor;
exports.getStatePositionAnchorAbsolute = getStatePositionAnchorAbsolute;
const getStatePositionAbsolute = state => state.selection.main.head;
exports.getStatePositionAbsolute = getStatePositionAbsolute;
const getStateEditorSupport = state => state.field(_cypherStateDefinitions.editorSupportField, false);
exports.getStateEditorSupport = getStateEditorSupport;
const getStateLineCount = state => state.doc.lines;
exports.getStateLineCount = getStateLineCount;
const getStateValue = state => state.doc.toString();
exports.getStateValue = getStateValue;
const getStateLength = state => state.doc.length;
exports.getStateLength = getStateLength;
const getStateLineObjectForLine = (state, line) => state.doc.line(line);
exports.getStateLineObjectForLine = getStateLineObjectForLine;
const getStateLineObjectForAbsolute = (state, position) => state.doc.lineAt(position);
exports.getStateLineObjectForAbsolute = getStateLineObjectForAbsolute;
const getStatePositionAbsoluteForLineColumn = (state, {
  line,
  column
}) => state.doc.line(line).from + column;
exports.getStatePositionAbsoluteForLineColumn = getStatePositionAbsoluteForLineColumn;
const getStatePositionForAbsolute = (state, position) => {
  const {
    number: line,
    from: lineStart
  } = getStateLineObjectForAbsolute(state, position);
  const column = position - lineStart;
  return {
    line,
    column,
    position
  };
};
exports.getStatePositionForAbsolute = getStatePositionForAbsolute;
const getStatePosition = state => getStatePositionForAbsolute(state, getStatePositionAbsolute(state));
exports.getStatePosition = getStatePosition;
const getStatePositionAnchor = state => getStatePositionForAbsolute(state, getStatePositionAnchorAbsolute(state));
exports.getStatePositionAnchor = getStatePositionAnchor;
const getStatePositionForAny = (state, positionValue) => {
  let position = null;
  if ((0, _cypherCodemirrorBase.isAbsolutePosition)(positionValue)) {
    position = positionValue;
  } else if ((0, _cypherCodemirrorBase.isLineColumnAbsolutePosition)(positionValue)) {
    position = positionValue.position;
  } else if ((0, _cypherCodemirrorBase.isLineColumnPosition)(positionValue)) {
    const {
      line,
      column
    } = positionValue;
    const lineCount = getStateLineCount(state);
    if (line <= lineCount) {
      const lineObject = getStateLineObjectForLine(state, line);
      if (lineObject) {
        const {
          from,
          to
        } = lineObject;
        if ((0, _cypherCodemirrorBase.isInteger)(from) && (0, _cypherCodemirrorBase.isInteger)(to) && column <= to - from) {
          position = from + column;
        }
      }
    }
  }
  if (position !== null) {
    if (position <= getStateLength(state)) {
      const lineObject = getStateLineObjectForAbsolute(state, position);
      if (lineObject) {
        const {
          number: line,
          from: lineStart,
          to: lineEnd
        } = lineObject;
        const column = position - lineStart;
        if (lineStart + column <= lineEnd) {
          position = {
            line,
            column,
            position
          };
        } else {
          position = null;
        }
      } else {
        position = null;
      }
    } else {
      position = null;
    }
  }
  return position;
};
exports.getStatePositionForAny = getStatePositionForAny;
const getStateSelection = state => state.selection;
exports.getStateSelection = getStateSelection;
const getStateHasSelection = state => state.selection.ranges.some(r => !r.empty);
exports.getStateHasSelection = getStateHasSelection;
const getSearchState = state => state.field(searchStateField, false);
exports.getSearchState = getSearchState;
const getStateSearchOpen = state => (getSearchState(state) || {
  panel: null
}).panel !== null;
exports.getStateSearchOpen = getStateSearchOpen;
const getStateSearchMatches = (state, maxCount = 1000) => {
  const matches = (getSearchState(state) || {
    query: {
      matchAll: () => null
    }
  }).query.matchAll(state, 1000);
  return matches ? matches.slice(0, maxCount) : matches;
};
exports.getStateSearchMatches = getStateSearchMatches;
const getStateSearchSpec = state => (getSearchState(state) || {
  query: {
    spec: null
  }
}).query.spec;
exports.getStateSearchSpec = getStateSearchSpec;
const getStateSearchText = state => (getSearchState(state) || {
  query: {
    spec: {
      search: null
    }
  }
}).query.spec.search;
exports.getStateSearchText = getStateSearchText;
const getAutocompleteState = state => state.field(autocompletionStateField, false);
exports.getAutocompleteState = getAutocompleteState;
const getStateAutocompleteOpen = state => (getAutocompleteState(state) || {
  open: null
}).open !== null;
exports.getStateAutocompleteOpen = getStateAutocompleteOpen;
const getFormattedAutocompleteOption = option => _objectSpread({
  from: option.source.from
}, option.completion);
exports.getFormattedAutocompleteOption = getFormattedAutocompleteOption;
const getStateAutocompleteOptions = (state, format = false) => {
  const {
    open
  } = getAutocompleteState(state) || {
    open: null
  };
  if (open !== null) {
    const {
      options
    } = open;
    if (options) {
      return format ? options.map(getFormattedAutocompleteOption) : options;
    }
    return [];
  }
  return null;
};
exports.getStateAutocompleteOptions = getStateAutocompleteOptions;
const areViewUpdateAutocompleteOptionsEqual = v => {
  const {
    startState: oldState,
    state: newState
  } = v;
  const {
    open: oldOpen
  } = getAutocompleteState(oldState) || {
    open: null
  };
  const {
    open: newOpen
  } = getAutocompleteState(newState) || {
    open: null
  };
  if (oldOpen === null || newOpen === null) {
    return oldOpen === newOpen;
  } else {
    const {
      options: oldOptions
    } = oldOpen;
    const {
      options: newOptions
    } = newOpen;
    if (!oldOptions || !newOptions) {
      return oldOptions === newOptions;
    } else {
      const {
        length: oldLength
      } = oldOptions;
      const {
        length: newLength
      } = newOptions;
      if (!oldLength || !newLength || oldLength !== newLength) {
        return oldLength === newLength;
      }
      for (let i = 0; i < newLength; i++) {
        const oldOption = oldOptions[i];
        const newOption = oldOptions[i];
        if (oldOption.source.from !== newOption.source.from || oldOption.completion !== newOption.completion) {
          return false;
        }
      }
      return true;
    }
  }
};
exports.areViewUpdateAutocompleteOptionsEqual = areViewUpdateAutocompleteOptionsEqual;
const getViewUpdateAnnotationValueForType = (v, type) => {
  for (let transaction of v.transactions) {
    const {
      annotations
    } = transaction;
    const foundAnnotation = annotations.find(a => a.type === type);
    if (foundAnnotation && foundAnnotation.value) {
      return foundAnnotation.value;
    }
  }
  return null;
};
exports.getViewUpdateAnnotationValueForType = getViewUpdateAnnotationValueForType;
const getViewUpdatePickedAutocompleteOption = (v, format = false) => {
  const pickedAutocompletion = getViewUpdateAnnotationValueForType(v, _autocomplete.pickedCompletion);
  if (pickedAutocompletion) {
    const pickedAutocompleteOption = getStateAutocompleteOptions(v.startState, false).find(({
      completion
    }) => completion == pickedAutocompletion);
    if (pickedAutocompleteOption) {
      return format ? getFormattedAutocompleteOption(pickedAutocompleteOption) : pickedAutocompleteOption;
    }
  }
  return null;
};
exports.getViewUpdatePickedAutocompleteOption = getViewUpdatePickedAutocompleteOption;