import type { Faker } from '../..';
/**
 * Module to generate music related entries.
 */
export declare class MusicModule {
    private readonly faker;
    constructor(faker: Faker);
    /**
     * Returns a random music genre.
     *
     * @example
     * faker.music.genre() // 'Reggae'
     *
     * @since 5.2.0
     */
    genre(): string;
    /**
     * Returns a random song name.
     *
     * @example
     * faker.music.songName() // 'White Christmas'
     *
     * @since 7.1.0
     */
    songName(): string;
}
