// Copyright 2025 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0

import { BasePath, BaseSVG, BaseSVGProps } from './utils';

export const BHCELogo: React.FC<BaseSVGProps> = (props) => {
    return (
        <BaseSVG
            name='bhce-logo'
            version='1.1'
            xmlns='http://www.w3.org/2000/svg'
            viewBox='0 0 310 250'
            color='#E02F35'
            {...props}>
            <rect width='309.406' height='250' rx='6' fill='currentColor' />
            <BasePath
                color='white'
                d='M278.044 194.729C278.044 194.729 278.018 194.729 278 194.729L273.163 181.542C273.956 180.889 274.467 179.909 274.467 178.797C274.467 177.49 273.762 176.361 272.713 175.734L273.304 172.786C275.075 172.574 276.449 171.074 276.449 169.246C276.449 167.269 274.846 165.663 272.872 165.663C272.652 165.663 272.431 165.689 272.22 165.725L257.426 143.614C257.858 143.023 258.131 142.29 258.131 141.505C258.131 139.528 256.527 137.921 254.554 137.921C254.025 137.921 253.532 138.045 253.082 138.248L239.152 123.728C239.399 123.243 239.54 122.704 239.54 122.131C239.54 120.153 237.936 118.547 235.963 118.547C235.372 118.547 234.817 118.706 234.324 118.962L222.808 108.167C223.002 107.726 223.107 107.24 223.107 106.737C223.107 104.76 221.504 103.154 219.53 103.154C218.94 103.154 218.385 103.312 217.891 103.568L208.754 95.0067C208.948 94.5653 209.054 94.0799 209.054 93.5768C209.054 91.5996 207.45 89.9932 205.477 89.9932C204.428 89.9932 203.503 90.4522 202.842 91.1671L172.479 78.2981C172.479 76.3209 170.876 74.7233 168.902 74.7233C167.624 74.7233 166.514 75.3941 165.88 76.4004L137.852 72.1107C137.544 70.4425 136.09 69.1714 134.336 69.1714C132.777 69.1714 131.464 70.1777 130.971 71.5723H114.115C113.622 70.1688 112.309 69.1714 110.758 69.1714C108.917 69.1714 107.419 70.566 107.225 72.3578L92.1406 75.8796C91.5062 74.8822 90.396 74.2202 89.136 74.2202C87.4707 74.2202 86.0786 75.3677 85.6821 76.9211L74.8886 77.9009C74.3247 76.674 73.0912 75.809 71.6462 75.809C70.5889 75.809 69.6461 76.2768 68.9853 77.0182L56.5001 71.9077C56.5089 71.7929 56.5353 71.6782 56.5353 71.5634C56.5353 69.5863 54.9317 67.9799 52.958 67.9799C52.3413 67.9799 51.7597 68.1564 51.2487 68.43L41.8914 59.0563L37.9177 50.1591C38.7106 49.506 39.2305 48.5174 39.2305 47.4053C39.2305 45.6929 38.0234 44.263 36.4198 43.91L35.988 28.6577L33.9527 27.8457L30.5076 31.2969L30.1816 31.9324L27.926 44.4131V44.8191L29.6177 55.0843C28.5604 55.711 27.8467 56.8496 27.8467 58.1648C27.8467 60.1419 29.4503 61.7484 31.4239 61.7484C31.6178 61.7484 31.8028 61.7219 31.979 61.6954L35.7678 68.0946C35.2479 68.7125 34.9307 69.5069 34.9307 70.3719C34.9307 72.349 36.5343 73.9554 38.508 73.9554C39.2041 73.9554 39.8473 73.7436 40.4024 73.3993L57.8041 87.2305C57.6719 87.6012 57.5838 87.9984 57.5838 88.4221C57.5838 90.3992 59.1874 92.0056 61.1611 92.0056C62.333 92.0056 63.355 91.4319 64.0159 90.5669L74.4921 93.9122C74.5362 95.245 75.3027 96.3836 76.4129 96.9661L74.1573 113.189C72.5273 113.525 71.2937 114.963 71.2937 116.702C71.2937 118.441 72.4568 119.792 74.0252 120.171L74.9415 129.201C73.7344 129.774 72.8885 131.001 72.8885 132.431C72.8885 133.411 73.2762 134.293 73.9106 134.938L68.3949 146.209C68.2804 146.2 68.1658 146.174 68.0513 146.174C66.0776 146.174 64.474 147.78 64.474 149.758C64.474 150.296 64.5974 150.799 64.8088 151.258L54.4735 161.629C54.0065 161.409 53.4955 161.276 52.9404 161.276C50.9668 161.276 49.3632 162.883 49.3632 164.86C49.3632 166.042 49.9447 167.084 50.8258 167.737L46.4027 182.283C44.5083 182.372 42.984 183.925 42.984 185.849C42.984 187.773 44.5876 189.433 46.5613 189.433C46.7727 189.433 46.9666 189.406 47.1692 189.371L55.989 205.109C55.4163 205.744 55.0551 206.583 55.0551 207.501C55.0551 209.478 56.6587 211.084 58.6323 211.084C60.1743 211.084 61.4695 210.104 61.9805 208.736L81.5409 208.992L82.6864 207.43L80.7127 201.384C81.4969 200.731 82.0167 199.751 82.0167 198.639C82.0167 196.662 80.4131 195.055 78.4395 195.055C77.6377 195.055 76.8975 195.329 76.2984 195.779L66.4653 190.66C66.4917 190.501 66.5182 190.342 66.5182 190.174C66.5182 188.859 65.8045 187.72 64.756 187.103L67.0468 175.293C68.7738 175.037 70.0954 173.563 70.0954 171.762C70.0954 171.321 70.0073 170.897 69.8576 170.5L81.8053 160.402C82.3339 160.711 82.9419 160.905 83.6027 160.905C85.5764 160.905 87.18 159.299 87.18 157.322C87.18 156.651 86.9861 156.033 86.669 155.495L94.6782 145.936C95.0658 146.086 95.4888 146.174 95.9205 146.174C96.0879 146.174 96.2465 146.147 96.4051 146.13L102.661 158.266C102.062 158.911 101.683 159.767 101.683 160.711C101.683 161.815 102.194 162.785 102.969 163.447L98.9515 174.26C98.9515 174.26 98.9162 174.26 98.8986 174.26C96.925 174.26 95.3214 175.866 95.3214 177.844C95.3214 179.821 96.9073 181.409 98.881 181.427L106.3 202.849C105.665 203.493 105.269 204.385 105.269 205.365C105.269 207.342 106.873 208.948 108.846 208.948C109.313 208.948 109.763 208.851 110.168 208.683L118.908 217.086C118.706 217.536 118.582 218.031 118.582 218.56C118.582 220.537 120.186 222.144 122.16 222.144C123.719 222.144 125.023 221.146 125.517 219.752H139.253L140.337 218.066L137.808 212.426C138.451 211.781 138.857 210.881 138.857 209.893C138.857 207.915 137.253 206.309 135.279 206.309C134.372 206.309 133.543 206.662 132.918 207.218L126.891 204.305C126.909 204.173 126.926 204.049 126.926 203.917C126.926 201.975 125.376 200.395 123.446 200.342L116.767 179.671C117.622 179.017 118.177 177.994 118.177 176.837C118.177 175.893 117.807 175.046 117.217 174.41L125.032 159.467C125.199 159.493 125.358 159.52 125.534 159.52C127.508 159.52 129.112 157.913 129.112 155.936C129.112 154.586 128.363 153.429 127.261 152.82L129.737 137.956C130.477 137.824 131.138 137.48 131.64 136.968L152.302 146.854C152.293 146.96 152.267 147.065 152.267 147.18C152.267 148.248 152.743 149.193 153.483 149.855L146.857 167.693C146.857 167.693 146.822 167.693 146.804 167.693C144.83 167.693 143.227 169.299 143.227 171.277C143.227 172.671 144.029 173.863 145.192 174.454L142.46 195.452C140.857 195.805 139.65 197.235 139.65 198.948C139.65 200.925 141.253 202.531 143.227 202.531C143.473 202.531 143.711 202.505 143.94 202.461L152.064 216.618C151.703 217.183 151.483 217.845 151.483 218.569C151.483 220.546 153.086 222.153 155.06 222.153C156.62 222.153 157.924 221.155 158.417 219.761H178.999L180.039 217.969L175.854 210.634C176.391 210.007 176.735 209.204 176.735 208.304C176.735 206.327 175.131 204.72 173.158 204.72C172.171 204.72 171.272 205.117 170.629 205.771L161.739 201.507C161.748 201.384 161.774 201.26 161.774 201.137C161.774 199.671 160.893 198.409 159.633 197.853L160.937 179.962C162.602 179.653 163.862 178.197 163.862 176.44C163.862 175.619 163.571 174.869 163.104 174.26L172.153 161.744C172.471 161.841 172.805 161.903 173.158 161.903C174.946 161.903 176.418 160.588 176.682 158.867L179.511 158.328C180.066 159.273 181.026 159.935 182.163 160.067L183.546 166.201C182.497 166.828 181.793 167.958 181.793 169.273C181.793 171.25 183.396 172.857 185.37 172.857C185.44 172.857 185.511 172.839 185.581 172.839L194.789 197.58C193.996 198.233 193.476 199.221 193.476 200.333C193.476 202.311 195.08 203.917 197.053 203.917C197.573 203.917 198.075 203.802 198.516 203.599L207.829 213.75C207.688 214.129 207.6 214.544 207.6 214.977C207.6 216.954 209.204 218.56 211.177 218.56C212.622 218.56 213.856 217.704 214.42 216.468H234.077L235.055 214.588L227.997 204.526C228.306 203.996 228.491 203.387 228.491 202.734C228.491 200.757 226.887 199.151 224.914 199.151C223.9 199.151 222.993 199.574 222.341 200.245L214.525 196.988C214.534 196.882 214.561 196.785 214.561 196.679C214.561 194.817 213.133 193.299 211.318 193.131L205.168 167.861C206.076 167.261 206.684 166.263 206.763 165.107L213.001 163.35C213.653 164.26 214.71 164.86 215.909 164.86C216.896 164.86 217.786 164.463 218.429 163.818L224.949 166.916C224.949 167.013 224.922 167.11 224.922 167.216C224.922 168.276 225.389 169.22 226.121 169.873L221.944 179.847C221.874 179.847 221.812 179.829 221.742 179.829C219.768 179.829 218.164 181.436 218.164 183.413C218.164 185.39 219.768 186.997 221.742 186.997C222.156 186.997 222.543 186.908 222.914 186.785L234.015 200.651C233.681 201.198 233.469 201.843 233.469 202.531C233.469 204.508 235.073 206.115 237.046 206.115C239.02 206.115 240.624 204.508 240.624 202.531C240.624 201.64 240.289 200.828 239.743 200.201L244.368 192.072C244.545 192.116 244.738 192.134 244.923 192.151L247.223 201.719C246.245 202.355 245.593 203.458 245.593 204.72C245.593 206.697 247.197 208.304 249.17 208.304C250.404 208.304 251.488 207.677 252.131 206.733L266.995 210.634C267.409 212.161 268.784 213.291 270.431 213.291C272.405 213.291 274.009 211.684 274.009 209.707C274.009 208.992 273.797 208.339 273.436 207.783L277.189 201.852C277.445 201.913 277.709 201.949 277.982 201.949C279.956 201.949 281.56 200.342 281.56 198.365C281.56 196.388 279.956 194.782 277.982 194.782L278.044 194.729ZM237.099 198.904C237.099 198.904 237.064 198.904 237.046 198.904L230.13 170.376C231.31 169.794 232.13 168.585 232.13 167.172C232.13 166.501 231.936 165.875 231.61 165.336L252.659 144.515C252.809 144.612 252.959 144.691 253.118 144.762L248.439 168.143C246.518 168.205 244.976 169.776 244.976 171.718C244.976 173.165 245.84 174.401 247.073 174.975L245.073 184.984C243.179 185.081 241.672 186.635 241.672 188.55C241.672 189.371 241.954 190.112 242.421 190.721L237.734 198.974C237.531 198.939 237.32 198.912 237.108 198.912L237.099 198.904ZM212.411 161.011L206.181 162.759C205.529 161.841 204.472 161.232 203.265 161.232C202.058 161.232 200.974 161.841 200.331 162.777L186.163 157.057C186.189 156.872 186.216 156.686 186.216 156.492C186.216 155.813 186.013 155.186 185.687 154.639L198.736 141.973C199.3 142.334 199.961 142.555 200.683 142.555C201.186 142.555 201.661 142.449 202.093 142.264L213.345 158.814C212.807 159.396 212.464 160.164 212.411 161.011ZM200.666 200.148L207.917 198.365C208.402 199.239 209.221 199.892 210.226 200.13L210.146 211.552C209.9 211.631 209.662 211.737 209.433 211.87L200.296 201.913C200.542 201.428 200.692 200.89 200.692 200.307C200.692 200.254 200.675 200.201 200.675 200.148H200.666ZM188.507 171.029C188.815 170.5 189 169.9 189 169.246C189 167.446 187.669 165.963 185.943 165.716L184.55 159.528C184.956 159.273 185.308 158.937 185.581 158.549L199.749 164.268C199.723 164.454 199.697 164.639 199.697 164.833C199.697 166.687 201.106 168.196 202.913 168.381L208.992 193.352L188.515 171.038L188.507 171.029ZM169.783 209.248L157.615 215.956C156.972 215.33 156.091 214.933 155.122 214.933C154.743 214.933 154.382 215.012 154.038 215.118L146.029 201.172C146.293 200.854 146.496 200.492 146.637 200.104L154.69 201.357C154.822 203.22 156.355 204.685 158.241 204.685C159.228 204.685 160.126 204.288 160.77 203.635L169.66 207.898C169.651 208.021 169.625 208.145 169.625 208.269C169.625 208.613 169.686 208.93 169.774 209.248H169.783ZM149.8 173.263L156.787 176.061C156.778 176.175 156.752 176.281 156.752 176.405C156.752 177.217 157.034 177.958 157.492 178.558L144.945 195.241L147.606 174.728C148.513 174.534 149.289 173.995 149.8 173.263ZM154.928 199.777L146.822 198.515C146.742 197.765 146.434 197.085 145.958 196.547L158.611 179.732L157.307 197.659C156.223 197.959 155.342 198.745 154.937 199.777H154.928ZM160.329 172.821C160.329 172.821 160.311 172.821 160.303 172.821L157.087 150.499C158.479 150.005 159.474 148.69 159.474 147.136C159.474 146.465 159.28 145.839 158.954 145.3L165.386 139.369C165.853 139.704 166.4 139.925 166.99 140.013L171.457 155.168C170.365 155.786 169.625 156.934 169.625 158.275C169.625 159.034 169.862 159.732 170.259 160.305L161.148 172.91C160.884 172.848 160.611 172.804 160.329 172.804V172.821ZM105.313 157.092C105.146 157.092 104.987 157.119 104.828 157.145L98.5726 145.009C98.6607 144.921 98.74 144.815 98.8105 144.718L122.08 155.195C122.036 155.424 122.01 155.662 122.01 155.901C122.01 155.901 122.01 155.918 122.01 155.927L108.511 159.105C107.93 157.922 106.723 157.092 105.313 157.092ZM83.6468 153.712C83.5763 153.712 83.5146 153.729 83.4529 153.729L78.2192 135.529C79.3206 134.92 80.0695 133.755 80.0695 132.405C80.0695 130.719 78.9064 129.315 77.3381 128.936L76.4217 119.906C76.4217 119.906 76.457 119.889 76.4746 119.88L93.1539 140.375C92.6781 140.984 92.3873 141.734 92.3873 142.564C92.3873 143.226 92.5811 143.844 92.8983 144.373L84.8891 153.95C84.5014 153.809 84.0873 153.712 83.6468 153.712ZM41.9178 71.4575L49.4601 72.1548C49.7508 73.8407 51.2135 75.1205 52.9757 75.1205C53.2048 75.1205 53.4338 75.094 53.6541 75.0499L58.4914 84.6796L41.9002 71.5016C41.9002 71.5016 41.9002 71.4752 41.909 71.4575H41.9178ZM64.3507 86.7627L69.5492 82.2612C70.1395 82.6937 70.8708 82.9673 71.655 82.9673C71.8929 82.9673 72.122 82.9408 72.3511 82.8967L75.9371 90.9288C75.6728 91.123 75.4437 91.3613 75.2411 91.6261L64.7472 88.272C64.7295 87.7336 64.5798 87.2217 64.3507 86.7715V86.7627ZM204.093 96.8514C204.525 97.0279 204.992 97.1339 205.485 97.1339C206.076 97.1339 206.631 96.975 207.124 96.719L216.261 105.281C216.067 105.722 215.962 106.208 215.962 106.711C215.962 108.264 216.957 109.579 218.341 110.074L216.763 123.446C215.627 123.569 214.649 124.214 214.094 125.149L191.476 117.744C191.476 117.664 191.502 117.585 191.502 117.505C191.502 116.711 191.238 115.978 190.797 115.387L204.102 96.8514H204.093ZM184.841 115.722L162.259 109.244C162.259 109.182 162.276 109.12 162.276 109.05C162.276 107.752 161.58 106.622 160.54 105.996L168.514 81.8198C168.647 81.8375 168.779 81.864 168.92 81.864C169.237 81.864 169.536 81.811 169.836 81.7316L185.872 114.584C185.449 114.884 185.105 115.272 184.841 115.722ZM137.817 93.3473C137.993 92.9236 138.09 92.4646 138.09 91.988C138.09 91.7938 138.064 91.6085 138.037 91.4231L165.88 80.1428C166.162 80.6106 166.55 81.0078 167.016 81.3079L159.034 105.519C158.919 105.51 158.813 105.484 158.699 105.484C157.783 105.484 156.954 105.837 156.32 106.411L137.826 93.3561L137.817 93.3473ZM137.447 89.9314C136.936 89.1988 136.16 88.6604 135.253 88.475L135.059 76.2503C136.116 76.0385 136.989 75.3588 137.491 74.4497L165.219 78.6953L137.447 89.9491V89.9314ZM133.464 76.1885L133.667 88.5103C132.107 88.8987 130.944 90.2933 130.944 91.9792C130.944 92.1734 130.971 92.3587 130.997 92.5441L121.067 96.569C120.468 95.6157 119.428 94.9714 118.23 94.9096L112.547 75.8443C113.287 75.4206 113.86 74.7498 114.15 73.9378H131.006C131.402 75.0499 132.319 75.8973 133.473 76.1974L133.464 76.1885ZM96.7928 139.077L96.9514 111.009C97.3126 110.93 97.6563 110.78 97.9647 110.603L125.948 132.855C125.728 133.323 125.587 133.843 125.587 134.399C125.587 134.417 125.587 134.435 125.587 134.461L99.1453 140.966C98.6783 140.031 97.8149 139.333 96.7752 139.086L96.7928 139.077ZM126.944 131.61L99.1453 109.509C99.5242 108.935 99.7533 108.255 99.7533 107.514C99.7533 107.32 99.7269 107.134 99.7004 106.949L115.225 100.664C115.877 101.512 116.891 102.068 118.045 102.068C118.265 102.068 118.477 102.041 118.688 102.006L127.42 131.301C127.252 131.398 127.103 131.504 126.953 131.619L126.944 131.61ZM110.785 76.3209C110.864 76.3209 110.934 76.3033 111.014 76.2944L116.644 95.1744C115.358 95.7216 114.459 96.9926 114.459 98.4755C114.459 98.7315 114.485 98.9786 114.538 99.2169L99.1013 105.466C98.4581 104.539 97.3831 103.93 96.1672 103.93C95.1363 103.93 94.2112 104.372 93.5592 105.069L81.2942 95.3156C81.5145 94.8478 81.6555 94.327 81.6555 93.771C81.6555 92.8442 81.2942 91.9968 80.7127 91.3613L87.8144 81.0961C88.2285 81.2638 88.6779 81.3609 89.1448 81.3609C90.9863 81.3609 92.4842 79.9574 92.6869 78.1657L107.771 74.6527C108.406 75.6501 109.516 76.3121 110.776 76.3121L110.785 76.3209ZM86.5192 80.1869L79.4175 90.4522C79.0034 90.2845 78.554 90.1874 78.087 90.1874C77.8491 90.1874 77.6201 90.2139 77.391 90.258L73.8049 82.2259C74.4393 81.7404 74.9151 81.0608 75.1177 80.2576L85.9112 79.2778C86.0698 79.6132 86.2725 79.9221 86.5192 80.1958V80.1869ZM80.3074 96.5601L92.7662 106.463C92.6604 106.799 92.59 107.143 92.59 107.514C92.59 109.209 93.7706 110.63 95.3566 111L95.198 139.069C94.916 139.13 94.6517 139.236 94.3962 139.36L77.717 118.865C78.1928 118.256 78.4835 117.505 78.4835 116.676C78.4835 115.29 77.6905 114.107 76.5539 113.507L78.8095 97.2839C79.3734 97.1692 79.8845 96.9044 80.3162 96.5601H80.3074ZM122.75 153.747L99.4801 143.27C99.5242 143.041 99.5506 142.802 99.5506 142.564C99.5506 142.546 99.5506 142.529 99.5506 142.502L125.992 135.997C126.318 136.641 126.821 137.162 127.446 137.515L124.97 152.379C124.063 152.538 123.287 153.041 122.75 153.747ZM131.288 131.522C130.689 131.081 129.966 130.807 129.164 130.807C129.085 130.807 129.015 130.825 128.935 130.833L120.142 101.353C121.032 100.7 121.613 99.6582 121.613 98.4667C121.613 98.3343 121.587 98.2019 121.578 98.0783L131.587 94.0269C132.231 94.9537 133.306 95.5627 134.522 95.5627C135.438 95.5627 136.266 95.2097 136.9 94.6359L155.395 107.69C155.219 108.114 155.122 108.573 155.122 109.05C155.122 109.65 155.28 110.206 155.545 110.709L131.297 131.522H131.288ZM161.818 110.78L184.374 117.249C184.374 117.338 184.348 117.426 184.348 117.514C184.348 118.159 184.533 118.759 184.832 119.288L169.44 133.49C168.876 133.128 168.215 132.908 167.492 132.908C167.184 132.908 166.884 132.961 166.594 133.031L160.443 112.165C161.025 111.839 161.492 111.362 161.818 110.78ZM173.211 154.7C173.131 154.7 173.061 154.718 172.99 154.727L168.611 139.872C170.039 139.395 171.07 138.071 171.07 136.482C171.07 135.803 170.867 135.167 170.541 134.629L185.898 120.462C186.471 120.86 187.167 121.098 187.925 121.098C188.383 121.098 188.824 121.001 189.229 120.842L198.322 136.306C197.582 136.959 197.106 137.912 197.106 138.98C197.106 139.66 197.309 140.296 197.635 140.834L184.586 153.5C184.022 153.129 183.361 152.917 182.638 152.917C180.85 152.917 179.378 154.233 179.114 155.954L176.286 156.492C175.669 155.433 174.523 154.709 173.211 154.709V154.7ZM203.027 136.288C202.401 135.741 201.582 135.388 200.683 135.388C200.349 135.388 200.023 135.45 199.714 135.538L190.533 119.942C190.718 119.739 190.877 119.518 191.018 119.28L213.6 126.676C213.591 126.782 213.565 126.888 213.565 127.003C213.565 127.506 213.671 127.983 213.856 128.415L203.018 136.288H203.027ZM218.349 123.64L219.927 110.268C220.376 110.224 220.799 110.091 221.178 109.888L232.694 120.683C232.5 121.124 232.394 121.61 232.394 122.122C232.394 123.622 233.311 124.902 234.615 125.432L231.918 141.54C231.416 141.567 230.949 141.699 230.526 141.92L219.979 129.183C220.438 128.583 220.728 127.832 220.728 127.012C220.728 125.458 219.733 124.143 218.349 123.649V123.64ZM232.359 148.654C234.227 148.531 235.707 146.995 235.707 145.097C235.707 143.597 234.791 142.317 233.487 141.787L236.183 125.679C236.632 125.652 237.055 125.555 237.443 125.37L251.373 139.881C251.126 140.366 250.977 140.913 250.977 141.496C250.977 142.193 251.188 142.846 251.532 143.394L230.509 164.189C230.315 164.065 230.112 163.951 229.901 163.871L232.359 148.663V148.654ZM267.312 178.797C267.312 178.885 267.33 178.973 267.339 179.053L262.977 180.394C262.36 179.326 261.215 178.594 259.893 178.594C259.215 178.594 258.589 178.797 258.043 179.123L251.708 173.386C251.928 172.962 252.069 172.503 252.104 172L269.392 170.032C269.603 170.968 270.185 171.762 270.969 172.256L270.37 175.257C268.634 175.504 267.303 176.987 267.303 178.788L267.312 178.797ZM269.392 168.434L251.884 170.429C251.54 169.547 250.862 168.832 249.999 168.452L254.677 145.062C254.95 145.053 255.206 145.009 255.453 144.947L270.158 166.925C269.797 167.358 269.524 167.861 269.392 168.434ZM246.642 185.249L248.633 175.301C249.399 175.284 250.104 175.028 250.677 174.604L256.898 180.235C256.536 180.8 256.316 181.462 256.316 182.186C256.316 183.325 256.854 184.331 257.691 184.984L250.007 201.19C249.875 201.163 249.743 201.154 249.602 201.137L247.285 191.498C248.219 190.854 248.836 189.777 248.836 188.55C248.836 187.067 247.937 185.787 246.65 185.249H246.642ZM251.426 201.878L259.109 185.673C259.356 185.726 259.62 185.761 259.884 185.761C260.052 185.761 260.211 185.734 260.369 185.708L268.334 206.803C267.867 207.156 267.488 207.624 267.242 208.163L252.765 204.367C252.677 203.352 252.175 202.469 251.426 201.869V201.878ZM270.493 206.08C270.255 206.08 270.017 206.106 269.788 206.15L261.867 185.17C261.955 185.108 262.034 185.037 262.122 184.967L274.943 196.573C274.652 197.094 274.476 197.677 274.476 198.312C274.476 199.151 274.775 199.901 275.251 200.51L271.612 206.265C271.26 206.15 270.889 206.071 270.502 206.071L270.493 206.08ZM275.55 194.985L263.109 183.722C263.33 183.254 263.462 182.742 263.462 182.186C263.462 182.098 263.444 182.01 263.435 181.93L267.797 180.589C268.414 181.657 269.559 182.389 270.881 182.389C270.898 182.389 270.907 182.389 270.925 182.389L275.55 194.993V194.985ZM202.816 95.907L189.581 114.346C189.088 114.081 188.524 113.922 187.925 113.922C187.731 113.922 187.537 113.948 187.352 113.984L171.246 80.9813C171.413 80.8401 171.563 80.6812 171.695 80.5135L201.935 93.3384C201.935 93.4091 201.917 93.4797 201.917 93.5503C201.917 94.4594 202.269 95.2803 202.824 95.907H202.816ZM68.0954 79.2072C68.0954 79.2602 68.0777 79.3131 68.0777 79.3749C68.0777 79.9839 68.2451 80.5488 68.5095 81.0519L63.3286 85.5446C62.7294 85.0945 61.9981 84.8209 61.1875 84.8209C60.9144 84.8209 60.6412 84.8562 60.3857 84.918L55.0991 74.4056C55.2401 74.2997 55.3811 74.1849 55.5132 74.0613L68.0954 79.2072ZM49.6627 70.1777C49.6099 70.3012 49.5834 70.4336 49.5394 70.566L42.05 69.8687C41.8209 68.1123 40.3319 66.753 38.5168 66.753C38.2789 66.753 38.0498 66.7795 37.8207 66.8236L34.0761 60.5126C34.3228 60.239 34.5342 59.9213 34.6928 59.577L39.9266 60.3802L40.0587 60.5656L49.6539 70.1777H49.6627ZM33.4505 50.168L31.935 54.3606L30.5693 46.0813L32.1641 46.7609C32.1288 46.9639 32.1024 47.1669 32.1024 47.3876C32.1024 48.5174 32.631 49.5148 33.4505 50.168ZM39.1248 58.6502L35.0012 58.0236C34.9572 56.8055 34.314 55.7375 33.3536 55.1196L34.8867 50.8741C35.1422 50.9359 35.4065 50.9712 35.6797 50.9712C35.6797 50.9712 35.6885 50.9712 35.6973 50.9712L39.1248 58.6591V58.6502ZM32.4813 32.7003L33.706 31.4734L34.0672 44.2012C33.5562 44.4572 33.1157 44.8368 32.7808 45.2957L30.3842 44.2718L32.4725 32.7003H32.4813ZM76.0869 135.944C76.2191 135.962 76.3513 135.988 76.4922 135.988C76.5627 135.988 76.6244 135.971 76.6861 135.971L81.9198 154.171C80.8184 154.78 80.0695 155.945 80.0695 157.295C80.0695 157.737 80.1576 158.16 80.3074 158.558L68.3597 168.655C68.1218 168.514 67.8575 168.399 67.5843 168.32L68.58 153.27C70.3157 153.023 71.6638 151.549 71.6638 149.74C71.6638 148.742 71.2585 147.842 70.5977 147.189L76.0957 135.962L76.0869 135.944ZM74.9415 198.992L61.4959 205.294C61.1787 204.888 60.7822 204.553 60.324 204.314L62.9233 193.731C62.9233 193.731 62.9585 193.731 62.985 193.731C63.9277 193.731 64.7824 193.361 65.4168 192.76L75.012 197.756C74.9415 198.03 74.8974 198.312 74.8974 198.612C74.8974 198.745 74.9239 198.868 74.9327 198.992H74.9415ZM49.7508 187.482C54.4559 188.735 57.4781 189.539 59.4165 190.051C59.4165 190.086 59.4077 190.112 59.4077 190.148C59.4077 191.551 60.2183 192.751 61.3814 193.334L58.7909 203.899C58.7909 203.899 58.7116 203.891 58.6676 203.891C58.4825 203.891 58.2975 203.917 58.1213 203.944L49.275 188.162C49.4601 187.95 49.6099 187.729 49.742 187.482H49.7508ZM59.8218 188.506C57.249 187.826 53.566 186.847 50.165 185.937C50.165 185.893 50.1738 185.849 50.1738 185.805C50.1738 184.622 49.5922 183.581 48.7111 182.928L53.1343 168.381C54.174 168.337 55.0815 167.843 55.7071 167.102L63.0995 170.853C63.029 171.135 62.985 171.418 62.985 171.718C62.985 173.033 63.6987 174.172 64.7472 174.79L62.4563 186.599C61.3021 186.776 60.3329 187.491 59.8218 188.497V188.506ZM66.994 153.12L65.9983 168.196C65.126 168.337 64.3683 168.788 63.822 169.441L56.4296 165.689C56.5001 165.407 56.5441 165.124 56.5441 164.824C56.5441 164.268 56.412 163.756 56.1829 163.289L66.5006 152.935C66.6592 153.015 66.8178 153.076 66.9852 153.129L66.994 153.12ZM79.9462 206.547L63.0466 206.327L75.4613 200.501C76.0957 201.507 77.2059 202.187 78.4835 202.187C78.5011 202.187 78.51 202.187 78.5276 202.187L79.9462 206.547ZM105.26 164.26C105.26 164.26 105.295 164.26 105.313 164.26C107.287 164.26 108.89 162.653 108.89 160.676C108.89 160.676 108.89 160.658 108.89 160.649L122.389 157.472C122.547 157.79 122.741 158.072 122.97 158.328L115.155 173.271C114.988 173.245 114.829 173.218 114.653 173.218C112.873 173.218 111.41 174.525 111.137 176.228L102.37 176.784C102.168 176.105 101.771 175.513 101.242 175.063L105.26 164.251V164.26ZM131.852 210.66L123.561 215.206C123.147 215.038 122.697 214.941 122.221 214.941C121.64 214.941 121.102 215.091 120.627 215.339L112.018 207.068C112.238 206.671 112.379 206.23 112.441 205.753L120.036 205.02C120.512 206.441 121.834 207.474 123.42 207.474C124.398 207.474 125.288 207.077 125.94 206.433L131.825 209.284C131.799 209.469 131.764 209.663 131.764 209.857C131.764 210.131 131.799 210.396 131.861 210.66H131.852ZM102.476 178.373L111.243 177.817C111.534 178.806 112.23 179.609 113.146 180.041L108.467 201.64L101.181 180.589C101.859 180.05 102.326 179.273 102.476 178.382V178.373ZM119.869 203.423L112.256 204.155C111.895 203.105 111.075 202.293 110.027 201.94L114.635 180.633L121.226 201.048C120.494 201.613 119.983 202.452 119.86 203.423H119.869ZM125.57 217.325C125.429 216.927 125.217 216.565 124.962 216.248L132.557 212.09C133.209 212.911 134.204 213.441 135.332 213.441C135.455 213.441 135.579 213.414 135.702 213.406L137.464 217.325H125.57ZM132.706 134.761C132.715 134.638 132.742 134.514 132.742 134.391C132.742 133.79 132.583 133.234 132.319 132.731L156.567 111.918C157.166 112.36 157.888 112.633 158.69 112.633C158.769 112.633 158.84 112.616 158.91 112.607L165.149 133.773C164.391 134.426 163.906 135.388 163.906 136.474C163.906 137.083 164.074 137.656 164.347 138.159L157.871 144.135C157.307 143.764 156.628 143.544 155.906 143.544C154.901 143.544 153.994 143.959 153.351 144.629L132.715 134.752L132.706 134.761ZM155.58 151.161L158.752 173.201C158.144 173.501 157.633 173.969 157.28 174.542L150.373 171.78C150.399 171.594 150.425 171.418 150.425 171.224C150.425 170.12 149.914 169.149 149.139 168.487L155.571 151.161H155.58ZM158.479 217.325C158.479 217.325 158.479 217.307 158.479 217.298L170.559 210.634C171.211 211.367 172.153 211.843 173.219 211.843C173.44 211.843 173.651 211.817 173.854 211.781L177.017 217.325H158.487H158.479ZM188.304 173.157L208.049 194.684C207.679 195.249 207.459 195.92 207.459 196.644C207.459 196.706 207.477 196.768 207.477 196.829L200.234 198.612C199.626 197.491 198.463 196.723 197.097 196.723C197.097 196.723 197.08 196.723 197.071 196.723L188.295 173.165L188.304 173.157ZM214.693 214.041C214.622 213.767 214.525 213.52 214.393 213.273L223.116 205.735C223.662 206.071 224.297 206.274 224.975 206.274C225.416 206.274 225.839 206.185 226.226 206.035L231.839 214.041H214.684H214.693ZM221.424 202.39C221.424 202.496 221.398 202.593 221.398 202.69C221.398 203.405 221.609 204.067 221.971 204.623L213.362 212.064C212.895 211.72 212.34 211.49 211.732 211.402L211.812 200.139C212.508 199.989 213.133 199.627 213.609 199.133L221.424 202.39ZM219.504 161.62C219.521 161.497 219.539 161.373 219.539 161.241C219.539 159.264 217.935 157.657 215.962 157.657C215.495 157.657 215.054 157.754 214.649 157.913L203.362 141.319C203.908 140.693 204.252 139.872 204.252 138.972C204.252 138.468 204.146 137.992 203.961 137.568L214.799 129.686C215.424 130.233 216.244 130.578 217.142 130.578C217.724 130.578 218.261 130.427 218.746 130.18L229.293 142.917C228.835 143.517 228.544 144.267 228.544 145.088C228.544 146.589 229.469 147.877 230.782 148.407L228.323 163.615C227.398 163.668 226.57 164.065 225.971 164.692L219.495 161.612L219.504 161.62ZM228.376 170.747C228.438 170.747 228.491 170.765 228.553 170.765C228.561 170.765 228.579 170.765 228.588 170.765L235.267 198.286L224.834 185.258C225.169 184.711 225.381 184.066 225.381 183.378C225.381 182.327 224.922 181.392 224.2 180.739L228.385 170.756L228.376 170.747Z'
            />
        </BaseSVG>
    );
};
