// copyright: Copyright (c) 2024 Lowell D. Thomas, all rights reserved<br>
//   license: BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)<br>
//
// Generated by apg-js, Version 4.4.0 [apg-js](https://github.com/ldthomas/apg-js)
export default function grammar(){
  // ```
  // SUMMARY
  //      rules = 5
  //       udts = 0
  //    opcodes = 12
  //        ---   ABNF original opcodes
  //        ALT = 0
  //        CAT = 2
  //        REP = 1
  //        RNM = 5
  //        TLS = 2
  //        TBS = 0
  //        TRG = 1
  //        ---   SABNF superset opcodes
  //        UDT = 0
  //        AND = 0
  //        NOT = 1
  // characters = [32 - 126]
  // ```
  /* OBJECT IDENTIFIER (for internal parser use) */
  this.grammarObject = 'grammarObject';

  /* RULES */
  this.rules = [];
  this.rules[0] = { name: 'C-lang', lower: 'c-lang', index: 0, isBkr: false };
  this.rules[1] = { name: 'begin', lower: 'begin', index: 1, isBkr: false };
  this.rules[2] = { name: 'comment', lower: 'comment', index: 2, isBkr: false };
  this.rules[3] = { name: 'end', lower: 'end', index: 3, isBkr: false };
  this.rules[4] = { name: 'any-char', lower: 'any-char', index: 4, isBkr: false };

  /* UDTS */
  this.udts = [];

  /* OPCODES */
  /* C-lang */
  this.rules[0].opcodes = [];
  this.rules[0].opcodes[0] = { type: 2, children: [1,2,3] };// CAT
  this.rules[0].opcodes[1] = { type: 4, index: 1 };// RNM(begin)
  this.rules[0].opcodes[2] = { type: 4, index: 2 };// RNM(comment)
  this.rules[0].opcodes[3] = { type: 4, index: 3 };// RNM(end)

  /* begin */
  this.rules[1].opcodes = [];
  this.rules[1].opcodes[0] = { type: 7, string: [47,42] };// TLS

  /* comment */
  this.rules[2].opcodes = [];
  this.rules[2].opcodes[0] = { type: 3, min: 0, max: Infinity };// REP
  this.rules[2].opcodes[1] = { type: 2, children: [2,4] };// CAT
  this.rules[2].opcodes[2] = { type: 13 };// NOT
  this.rules[2].opcodes[3] = { type: 4, index: 3 };// RNM(end)
  this.rules[2].opcodes[4] = { type: 4, index: 4 };// RNM(any-char)

  /* end */
  this.rules[3].opcodes = [];
  this.rules[3].opcodes[0] = { type: 7, string: [42,47] };// TLS

  /* any-char */
  this.rules[4].opcodes = [];
  this.rules[4].opcodes[0] = { type: 5, min: 32, max: 126 };// TRG

  // The `toString()` function will display the original grammar file(s) that produced these opcodes.
  this.toString = function toString(){
    let str = "";
    str += "; Note that the rule \"any-char\" accepts \"*\" and \"/\".\n";
    str += "; Without the negative look ahead operator *any-char would over run\n";
    str += "; the end of the string and never find the \"end\" rule.\n";
    str += "C-lang = begin comment end\n";
    str += "begin    = \"/*\"\n";
    str += "comment  = *(!end any-char)\n";
    str += "end      = \"*/\"\n";
    str += "any-char = %d32-126\n";
    return str;
  }
}
