"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var CypherTypes = _interopRequireWildcard(require("../../lang/CypherTypes"));
var CompletionTypes = _interopRequireWildcard(require("../CompletionTypes"));
var _TreeUtils = require("../../util/TreeUtils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
// If we are in console command, and not in console command name, return path
var _default = element => {
  let consoleCommand = _TreeUtils.TreeUtils.findParent(element.parentCtx, CypherTypes.CONSOLE_COMMAND_CONTEXT);
  let isAtTheEndOfConsoleCommand = false;
  if (!consoleCommand) {
    // We are not in console command. But maybe we are on a space at the end of console command?
    // If first child of parent contains console command
    // and second child is our current element
    // then we are at the space at the end of console command
    const parent = element.parentCtx;
    const child1 = _TreeUtils.TreeUtils.findChild(parent.children[0], CypherTypes.CONSOLE_COMMAND_CONTEXT);
    const child2 = parent.children[1];
    if (child1 && child2 && child2 === element) {
      consoleCommand = child1;
      isAtTheEndOfConsoleCommand = true;
    } else {
      return [];
    }
  }

  // Find current parameter or space
  const currentElement = _TreeUtils.TreeUtils.findParent(element, CypherTypes.CONSOLE_COMMAND_PARAMETER_CONTEXT) || element;
  const path = [];
  let currentElementInParameter = false;

  // Iterate over parameters, and stop when we found current one.
  for (let i = 0; i < consoleCommand.children.length; i += 1) {
    const child = consoleCommand.children[i];
    if (child instanceof CypherTypes.CONSOLE_COMMAND_NAME_CONTEXT) {
      path.push(child.getText());
    }
    if (child instanceof CypherTypes.CONSOLE_COMMAND_PARAMETERS_CONTEXT) {
      for (let j = 0; j < child.children.length; j += 1) {
        const parameterChild = child.children[j];
        if (parameterChild instanceof CypherTypes.CONSOLE_COMMAND_PARAMETER_CONTEXT) {
          path.push(parameterChild.getText());
          currentElementInParameter = true;
        } else {
          currentElementInParameter = false;
        }
        if (parameterChild === currentElement) {
          break;
        }
      }
    }
  }

  // If we are at the end of console command, nothing to filter.
  let filterLastElement;
  if (isAtTheEndOfConsoleCommand) {
    filterLastElement = false;
  } else {
    // If we are in parameter, filter, otherwise not
    filterLastElement = currentElementInParameter;
  }
  return [{
    type: CompletionTypes.CONSOLE_COMMAND_SUBCOMMAND,
    path,
    filterLastElement
  }];
};
exports.default = _default;