// Copyright 2025 Specter Ops, Inc.
//
// Licensed under the Apache License, Version 2.0
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// SPDX-License-Identifier: Apache-2.0
import { Card, CardContent, CardFooter, CardTitle } from '@bloodhoundenterprise/doodleui';
import { DateTime } from 'luxon';
import { LuxonFormat } from '../../..';
import { AppIcon } from '../../../components';
import { useHistoryTableContext } from './HistoryTableContext';

const HistoryNote = () => {
    const { selected } = useHistoryTableContext();

    return (
        <div>
            <Card className='flex justify-center mb-4 p-4 h-14 w-96 min-w-80 max-w-lg'>
                <CardTitle className='flex items-center gap-2'>
                    <AppIcon.LinedPaper size={24} className='-mb-[3px]' />
                    Note
                </CardTitle>
            </Card>

            {selected && (
                <Card className='p-4 '>
                    <CardContent>
                        <p className='text-xl'>{selected.note}</p>
                    </CardContent>
                    <CardFooter>
                        <p>
                            By {selected.email} on{' '}
                            {DateTime.fromISO(selected.created_at).toFormat(LuxonFormat.ISO_8601)}
                        </p>
                    </CardFooter>
                </Card>
            )}
        </div>
    );
};

export default HistoryNote;
