<!-- Documentation: https://agents.md -->

# AGENTS.md

## Golang code standards
- Golang code standards are enforced specifically for user or agent-written code, not code that is automatically generated by tooling (example: unit test mocks)
- Receiver functions on structs should prefer `s` as the variable name instead of the first letter of the struct type.
- Named returns are not allowed; all return variables must be defined in the function.
- Group variable initializations in a `var ( ... )` block and hoist them to the top of the function when possible.
- Use `any` instead of `interface{}`.
- Prefer rich variables names, for example: `databaseInterface` instead of `di` or `dbi`.

## PR instructions
- Title format: <conventional commit tag>: <Title> <Jira tag>
- Always run `just prepare-for-codereview` before committing to perform tests and do code generation and license checks.

## Test code instructions for Golang
- If a test file is testing internal (non-exported) logic, the file may be included in the same package as the code being tested.
- If a test file is only testing the external (exported) pieces of code, the file should use the same package as the code being tested with `_test` appended.
  - Example: `auth.go` has `package api`, `auth_test.go` is only testing exported logic in `auth.go` and should have `package api_test`
- Integration tests should be separated from unit tests, such that if we have an `auth.go` file, `auth_test.go` should have unit tests and `auth_integration_test.go` should have integration tests.
- Integration test files should have an `*integration` build tag at the top of the file, underneath the license header: example: `//go:build integration` or `//go:build serial_integration` or `//go:build slow_integration`

## Code review instructions
- The user should have run `just prepare-for-codereview` before creating a PR. This command runs tests locally, does code generation, adds license headers, and generates OpenAPI docs.
- There is no 100% positive way to identify that a user has run `just prepare-for-codereview`, but there are some smells to look for which indicate that a user might not have run it:
  - Code files must have a license header at the top of the file using a code comment block. The file `LICENSE.header` file has an up-to-date version of the header.
  - The file located at `cmd/api/src/database/db.go` contains a Database interface type. This interface must be implemented by the `MockDatabase` struct in `cmd/api/src/database/mocks/db.go` and is generated by `go.uber.org/mock/mockgen`.
  - If the code adds a new API endpoint, or it changes something about an existing API endpoint (url, models that get marshaled to JSON, query params, etc), there should probably be changes to the OpenAPI yaml files.
  - If OpenAPI yaml files have been changed, `openapi.json` should also have corresponding changes.
