/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.fs;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystemRoot;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public interface DBFVirtualFileSystem
extends Closeable {
    @NotNull
    public String getFileSystemDisplayName();

    @NotNull
    public String getType();

    public String getDescription();

    public DBPImage getIcon();

    @NotNull
    public String getId();

    @NotNull
    public String getProviderId();

    @NotNull
    public List<? extends DBFVirtualFileSystemRoot> getRootFolders(DBRProgressMonitor var1) throws DBException;

    @NotNull
    public Path getPathByURI(@NotNull DBRProgressMonitor var1, @NotNull URI var2) throws DBException;

    public String[] getURISegments(URI var1);

    default public void refreshRoots(DBRProgressMonitor monitor) throws DBException {
    }

    default public boolean supportsEmptyFolders() {
        return true;
    }

    default public boolean isDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    @Override
    default public void close() throws IOException {
    }
}

