/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.jparted.lib.ps.ebr;

import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.DataLocator;
import org.catacombae.jparted.lib.ps.Partition;
import org.catacombae.jparted.lib.ps.PartitionSystemHandler;
import org.catacombae.jparted.lib.ps.StandardPartition;
import org.catacombae.jparted.lib.ps.ebr.EBRPartitionSystem;

public class EBRHandler
extends PartitionSystemHandler {
    private DataLocator partitionData;

    public EBRHandler(DataLocator partitionData) {
        this.partitionData = partitionData;
    }

    public long getPartitionCount() {
        EBRPartitionSystem ps = this.readPartitionTable();
        return ps.getUsedPartitionCount();
    }

    public Partition[] getPartitions() {
        EBRPartitionSystem partitionTable = this.readPartitionTable();
        Partition[] result = new Partition[partitionTable.getUsedPartitionCount()];
        org.catacombae.hfsexplorer.partitioning.Partition[] parts = partitionTable.getUsedPartitionEntries();
        for (int i = 0; i < result.length; ++i) {
            result[i] = new StandardPartition(parts[i].getStartOffset(), parts[i].getLength(), parts[i].getType());
        }
        return result;
    }

    public void close() {
    }

    private EBRPartitionSystem readPartitionTable() {
        try {
            ReadableRandomAccessStream llf = this.partitionData.createReadOnlyFile();
            byte[] firstBlock = new byte[512];
            llf.readFully(firstBlock);
            EBRPartitionSystem ebs = new EBRPartitionSystem(llf, 0L, 512);
            if (ebs.isValid()) {
                return ebs;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

