/*
 * Decompiled with CFR 0.152.
 */
package com.jsql.view.swing.manager.util;

import com.jsql.util.LogLevelUtil;
import com.jsql.util.bruter.ActionCoder;
import com.jsql.view.swing.manager.ManagerCoder;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CoderListener
implements ActionListener {
    private static final Logger LOGGER = LogManager.getRootLogger();
    private final ManagerCoder coderManager;

    public CoderListener(ManagerCoder coderManager) {
        this.coderManager = coderManager;
    }

    public void actionPerformed() {
        this.transform(this.coderManager.getMenuMethod().getText());
    }

    public void actionPerformed(String nameMethod) {
        this.transform(nameMethod);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.coderManager.getMenuMethod().setText(actionEvent.getActionCommand());
        this.transform(this.coderManager.getMenuMethod().getText());
    }

    private void transform(String labelMethodMenu) {
        Object result;
        String nameMethod = labelMethodMenu.replace("Hash to ", "");
        String textInput = this.coderManager.getTextInput().getText();
        try {
            if (StringUtils.isEmpty(textInput) && !ActionCoder.getHashesEmpty().contains(nameMethod)) {
                throw new IllegalArgumentException("text to convert not found");
            }
            result = ActionCoder.forName(nameMethod).orElseThrow().run(textInput);
        }
        catch (IOException | IllegalArgumentException | NoSuchAlgorithmException e) {
            result = "Coder failure: " + e.getMessage();
            LOGGER.log(LogLevelUtil.IGNORE, e);
        }
        this.coderManager.getResult().setText((String)result);
    }
}

