// Copyright (C) 2025 Rivos Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated by the ProtoZero Rust compiler plugin.
// Invoked by contrib/rust-sdk/tools/gen_rust_protos
// DO NOT EDIT.

use crate::pb_enum;
use crate::pb_msg;

pb_enum!(VulkanMemoryEventSource {
    SOURCE_UNSPECIFIED: 0,
    SOURCE_DRIVER: 1,
    SOURCE_DEVICE: 2,
    SOURCE_DEVICE_MEMORY: 3,
    SOURCE_BUFFER: 4,
    SOURCE_IMAGE: 5,
});

pb_enum!(VulkanMemoryEventOperation {
    OP_UNSPECIFIED: 0,
    OP_CREATE: 1,
    OP_DESTROY: 2,
    OP_BIND: 3,
    OP_DESTROY_BOUND: 4,
    OP_ANNOTATIONS: 5,
});

pb_enum!(VulkanMemoryEventAllocationScope {
    SCOPE_UNSPECIFIED: 0,
    SCOPE_COMMAND: 1,
    SCOPE_OBJECT: 2,
    SCOPE_CACHE: 3,
    SCOPE_DEVICE: 4,
    SCOPE_INSTANCE: 5,
});

pb_msg!(VulkanMemoryEvent {
    source: VulkanMemoryEventSource, enum, 1,
    operation: VulkanMemoryEventOperation, enum, 2,
    timestamp: i64, primitive, 3,
    pid: u32, primitive, 4,
    memory_address: u64, primitive, 5,
    memory_size: u64, primitive, 6,
    caller_iid: u64, primitive, 7,
    allocation_scope: VulkanMemoryEventAllocationScope, enum, 8,
    annotations: VulkanMemoryEventAnnotation, msg, 9,
    device: u64, primitive, 16,
    device_memory: u64, primitive, 17,
    memory_type: u32, primitive, 18,
    heap: u32, primitive, 19,
    object_handle: u64, primitive, 20,
});

pb_msg!(VulkanMemoryEventAnnotation {
    key_iid: u64, primitive, 1,
    int_value: i64, primitive, 2,
    double_value: f64, primitive, 3,
    string_iid: u64, primitive, 4,
});
