\name{exactSNP}
\alias{exactSNP}
\title{Accurately and Efficiently call SNPs}
\description{Measure background noises and perform Fisher's Exact tests to detect SNPs.}
\usage{
exactSNP(

    # basic input/output options
    readFile,
    isBAM = FALSE,
    refGenomeFile,
    SNPAnnotationFile = NULL,
    outputFile = paste0(readFile, ".exactSNP.VCF"),

    # fine tuning parameters 
    qvalueCutoff = 12,
    minAllelicFraction = 0,
    minAllelicBases = 1,
    minReads = 1,
    maxReads = 1000000,
    minBaseQuality = 13,
    nTrimmedBases = 3,
    nthreads = 1)
}
\arguments{
  \item{readFile}{ a character string giving the name of a file including read mapping results. This function takes as input a SAM file by default. If a BAM file is provided, the \code{isBAM} argument should be set to \code{TRUE}. If the input is paired-end data, the reads have to be name sorted.}
  \item{isBAM}{ logical indicating if the file provided via \code{readFile} is a BAM file. \code{FALSE} by default.}
  \item{refGenomeFile}{ a character string giving the name of a file that includes reference sequences (FASTA format).}
  \item{SNPAnnotationFile}{ a character string giving the name of a VCF-format file that includes annotated SNPs (the file can be uncompressed or gzip compressed). Such annotation can be downloaded from public databases such as dbSNP. Incorporating known SNPs into SNP calling has been found to be helpful. However note that the annotated SNPs may or may not be called for the sample being analyzed.}
  \item{outputFile}{ a character string giving the name of the output file to be generated by this function. The output file includes all the reported SNPs (in VCF format). It includes discovered indels as well.}
  \item{qvalueCutoff}{ a numeric value giving the q-value cutoff for SNP calling at sequencing depth of 50X. \code{12} by default. The q-value is calcuated as -log10(p), where p is the p-value yielded from the Fisher's Exact test. Note that this function automatically adjusts the q-value cutoff for each chromosomal location according to its sequencing depth, based on this cutoff.}
  \item{minAllelicFraction}{ a numeric value giving the minimum fraction of allelic bases out of all read bases included at a chromosomal location required for SNP calling. Its value must be within \code{0} and \code{1}. \code{0} by default.}
  \item{minAllelicBases}{ an integer giving the minimum number of allelic (mis-matched) bases a SNP must have at a chromosomal location. \code{1} by default.}
  \item{minReads}{ an integer giving the minimum number of mapped reads a SNP-containing location must have (ie. the minimum coverage). \code{1} by default.}
  \item{maxReads}{ an integer specifying the maximum depth a SNP-containing location is allowed to have. \code{1000000} by default. Any location having number of mapped reads higher than this threshold will not be considered for SNP calling. This option is useful for removing PCR artefacts.}
  \item{minBaseQuality}{ a numeric value giving the minimum base quality score (Phred score) read bases should satisfy before being used for SNP calling. \code{13} by default(corresponding to base calling p value of 0.05). Read bases with quality scores less than 13 will be excluded from analysis.}
  \item{nTrimmedBases}{ a numeric value giving the number of bases trimmed off from each end of the read. \code{3} by default.}
  \item{nthreads}{ a numeric value giving the number of threads/CPUs used. \code{1} by default.}
}
\details{
This function takes as input a SAM/BAM format file, measures local background noise for each chromosomal location and then performs Fisher's exact tests to find statistically significant SNPs .

This function implements a novel algorithm for discovering SNPs.
This algorithm is comparable with or better than existing SNP callers, but it is fast more efficient.
It can be used to call SNPs for individual samples (ie. no control samples are required).
Detail of the algorithm is described in a manuscript which is currently under preparation.
}
\value{
No value is produced but but a VCF format file is written to the current working directory. This file contains detailed information for discovered SNPs including chromosomal locations, reference bases, alternative bases, read coverages, allele frequencies and p values. 
}
%\references{
%}
\author{Yang Liao and Wei Shi}
%\note{}
%\seealso{}
%\examples{}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
%\keyword{}
%\keyword{}% __ONLY ONE__ keyword per line
