% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{set_graph_attr}
\alias{set_graph_attr}
\title{Set a graph attribute}
\usage{
set_graph_attr(graph, name, value)
}
\arguments{
\item{graph}{The graph.}

\item{name}{The name of the attribute to set.}

\item{value}{New value of the attribute.}
}
\value{
The graph with the new graph attribute added or set.
}
\description{
An existing attribute with the same name is overwritten.
}
\examples{
g <- make_ring(10) \%>\%
  set_graph_attr("layout", layout_with_fr)
g
plot(g)
}
\seealso{
Vertex, edge and graph attributes
\code{\link{delete_edge_attr}()},
\code{\link{delete_graph_attr}()},
\code{\link{delete_vertex_attr}()},
\code{\link{edge_attr}()},
\code{\link{edge_attr<-}()},
\code{\link{edge_attr_names}()},
\code{\link{graph_attr}()},
\code{\link{graph_attr<-}()},
\code{\link{graph_attr_names}()},
\code{\link{igraph-attribute-combination}},
\code{\link{igraph-dollar}},
\code{\link{igraph-vs-attributes}},
\code{\link{set_edge_attr}()},
\code{\link{set_vertex_attr}()},
\code{\link{vertex_attr}()},
\code{\link{vertex_attr<-}()},
\code{\link{vertex_attr_names}()}
}
\concept{attributes}
