% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dots-ellipsis.R
\name{check_dots_unnamed}
\alias{check_dots_unnamed}
\title{Check that all dots are unnamed}
\usage{
check_dots_unnamed(
  env = caller_env(),
  error = NULL,
  call = caller_env(),
  action = abort
)
}
\arguments{
\item{env}{Environment in which to look for \code{...}.}

\item{error}{An optional error handler passed to \code{\link[=try_fetch]{try_fetch()}}. Use
this e.g. to demote an error into a warning.}

\item{call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[=abort]{abort()}} for more information.}

\item{action}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\description{
In functions like \code{paste()}, named arguments in \code{...} are often a
sign of misspelled argument names. Call \code{check_dots_unnamed()} to
fail with an error when named arguments are detected.
}
\examples{
f <- function(..., foofy = 8) {
  check_dots_unnamed()
  c(...)
}

f(1, 2, 3, foofy = 4)

try(f(1, 2, 3, foof = 4))
}
\seealso{
Other dots checking functions: 
\code{\link{check_dots_empty}()},
\code{\link{check_dots_used}()}
}
\concept{dots checking functions}
