// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::ffi;
use glib::translate::*;

glib::wrapper! {
    #[doc(alias = "PopplerMedia")]
    pub struct Media(Object<ffi::PopplerMedia>);

    match fn {
        type_ => || ffi::poppler_media_get_type(),
    }
}

impl Media {
    #[cfg(feature = "v20_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_4")))]
    #[doc(alias = "poppler_media_get_auto_play")]
    #[doc(alias = "get_auto_play")]
    pub fn is_auto_play(&self) -> bool {
        unsafe { from_glib(ffi::poppler_media_get_auto_play(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_media_get_filename")]
    #[doc(alias = "get_filename")]
    pub fn filename(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::poppler_media_get_filename(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_media_get_mime_type")]
    #[doc(alias = "get_mime_type")]
    pub fn mime_type(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::poppler_media_get_mime_type(self.to_glib_none().0)) }
    }

    #[cfg(feature = "v20_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_4")))]
    #[doc(alias = "poppler_media_get_repeat_count")]
    #[doc(alias = "get_repeat_count")]
    pub fn repeat_count(&self) -> f32 {
        unsafe { ffi::poppler_media_get_repeat_count(self.to_glib_none().0) }
    }

    #[cfg(feature = "v20_4")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v20_4")))]
    #[doc(alias = "poppler_media_get_show_controls")]
    #[doc(alias = "get_show_controls")]
    pub fn shows_controls(&self) -> bool {
        unsafe { from_glib(ffi::poppler_media_get_show_controls(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_media_is_embedded")]
    pub fn is_embedded(&self) -> bool {
        unsafe { from_glib(ffi::poppler_media_is_embedded(self.to_glib_none().0)) }
    }

    #[doc(alias = "poppler_media_save")]
    pub fn save(&self, filename: &str) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::poppler_media_save(
                self.to_glib_none().0,
                filename.to_glib_none().0,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    //#[doc(alias = "poppler_media_save_to_callback")]
    //pub fn save_to_callback<P: FnMut(&Vec<u8>, usize, Option<&glib::Error>) -> bool>(&self, save_func: P) -> Result<(), glib::Error> {
    //    unsafe { TODO: call ffi:poppler_media_save_to_callback() }
    //}

    #[cfg(target_os = "linux")]
    #[cfg_attr(docsrs, doc(cfg(target_os = "linux")))]
    #[cfg(feature = "v21_12")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v21_12")))]
    #[doc(alias = "poppler_media_save_to_fd")]
    pub fn save_to_fd(&self, fd: i32) -> Result<(), glib::Error> {
        unsafe {
            let mut error = std::ptr::null_mut();
            let is_ok = ffi::poppler_media_save_to_fd(self.to_glib_none().0, fd, &mut error);
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }
}
