package webaudio

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"fmt"
	"strings"

	"github.com/chromedp/cdproto/cdp"
)

// GraphObjectID an unique ID for a graph object (AudioContext, AudioNode,
// AudioParam) in Web Audio API.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#type-GraphObjectId
type GraphObjectID string

// String returns the GraphObjectID as string value.
func (t GraphObjectID) String() string {
	return string(t)
}

// ContextType enum of BaseAudioContext types.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#type-ContextType
type ContextType string

// String returns the ContextType as string value.
func (t ContextType) String() string {
	return string(t)
}

// ContextType values.
const (
	ContextTypeRealtime ContextType = "realtime"
	ContextTypeOffline  ContextType = "offline"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ContextType) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ContextType(s) {
	case ContextTypeRealtime:
		*t = ContextTypeRealtime
	case ContextTypeOffline:
		*t = ContextTypeOffline
	default:
		return fmt.Errorf("unknown ContextType value: %v", s)
	}
	return nil
}

// ContextState enum of AudioContextState from the spec.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#type-ContextState
type ContextState string

// String returns the ContextState as string value.
func (t ContextState) String() string {
	return string(t)
}

// ContextState values.
const (
	ContextStateSuspended   ContextState = "suspended"
	ContextStateRunning     ContextState = "running"
	ContextStateClosed      ContextState = "closed"
	ContextStateInterrupted ContextState = "interrupted"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ContextState) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ContextState(s) {
	case ContextStateSuspended:
		*t = ContextStateSuspended
	case ContextStateRunning:
		*t = ContextStateRunning
	case ContextStateClosed:
		*t = ContextStateClosed
	case ContextStateInterrupted:
		*t = ContextStateInterrupted
	default:
		return fmt.Errorf("unknown ContextState value: %v", s)
	}
	return nil
}

// NodeType enum of AudioNode types.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#type-NodeType
type NodeType string

// String returns the NodeType as string value.
func (t NodeType) String() string {
	return string(t)
}

// ChannelCountMode enum of AudioNode::ChannelCountMode from the spec.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#type-ChannelCountMode
type ChannelCountMode string

// String returns the ChannelCountMode as string value.
func (t ChannelCountMode) String() string {
	return string(t)
}

// ChannelCountMode values.
const (
	ChannelCountModeClampedMax ChannelCountMode = "clamped-max"
	ChannelCountModeExplicit   ChannelCountMode = "explicit"
	ChannelCountModeMax        ChannelCountMode = "max"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ChannelCountMode) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ChannelCountMode(s) {
	case ChannelCountModeClampedMax:
		*t = ChannelCountModeClampedMax
	case ChannelCountModeExplicit:
		*t = ChannelCountModeExplicit
	case ChannelCountModeMax:
		*t = ChannelCountModeMax
	default:
		return fmt.Errorf("unknown ChannelCountMode value: %v", s)
	}
	return nil
}

// ChannelInterpretation enum of AudioNode::ChannelInterpretation from the
// spec.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#type-ChannelInterpretation
type ChannelInterpretation string

// String returns the ChannelInterpretation as string value.
func (t ChannelInterpretation) String() string {
	return string(t)
}

// ChannelInterpretation values.
const (
	ChannelInterpretationDiscrete ChannelInterpretation = "discrete"
	ChannelInterpretationSpeakers ChannelInterpretation = "speakers"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *ChannelInterpretation) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch ChannelInterpretation(s) {
	case ChannelInterpretationDiscrete:
		*t = ChannelInterpretationDiscrete
	case ChannelInterpretationSpeakers:
		*t = ChannelInterpretationSpeakers
	default:
		return fmt.Errorf("unknown ChannelInterpretation value: %v", s)
	}
	return nil
}

// ParamType enum of AudioParam types.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#type-ParamType
type ParamType string

// String returns the ParamType as string value.
func (t ParamType) String() string {
	return string(t)
}

// AutomationRate enum of AudioParam::AutomationRate from the spec.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#type-AutomationRate
type AutomationRate string

// String returns the AutomationRate as string value.
func (t AutomationRate) String() string {
	return string(t)
}

// AutomationRate values.
const (
	AutomationRateARate AutomationRate = "a-rate"
	AutomationRateKRate AutomationRate = "k-rate"
)

// UnmarshalJSON satisfies [json.Unmarshaler].
func (t *AutomationRate) UnmarshalJSON(buf []byte) error {
	s := string(buf)
	s = strings.TrimSuffix(strings.TrimPrefix(s, `"`), `"`)

	switch AutomationRate(s) {
	case AutomationRateARate:
		*t = AutomationRateARate
	case AutomationRateKRate:
		*t = AutomationRateKRate
	default:
		return fmt.Errorf("unknown AutomationRate value: %v", s)
	}
	return nil
}

// ContextRealtimeData fields in AudioContext that change in real-time.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#type-ContextRealtimeData
type ContextRealtimeData struct {
	CurrentTime              float64 `json:"currentTime"`              // The current context time in second in BaseAudioContext.
	RenderCapacity           float64 `json:"renderCapacity"`           // The time spent on rendering graph divided by render quantum duration, and multiplied by 100. 100 means the audio renderer reached the full capacity and glitch may occur.
	CallbackIntervalMean     float64 `json:"callbackIntervalMean"`     // A running mean of callback interval.
	CallbackIntervalVariance float64 `json:"callbackIntervalVariance"` // A running variance of callback interval.
}

// BaseAudioContext protocol object for BaseAudioContext.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#type-BaseAudioContext
type BaseAudioContext struct {
	ContextID             GraphObjectID        `json:"contextId"`
	ContextType           ContextType          `json:"contextType"`
	ContextState          ContextState         `json:"contextState"`
	RealtimeData          *ContextRealtimeData `json:"realtimeData,omitempty,omitzero"`
	CallbackBufferSize    float64              `json:"callbackBufferSize"`    // Platform-dependent callback buffer size.
	MaxOutputChannelCount float64              `json:"maxOutputChannelCount"` // Number of output channels supported by audio hardware in use.
	SampleRate            float64              `json:"sampleRate"`            // Context sample rate.
}

// AudioListener protocol object for AudioListener.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#type-AudioListener
type AudioListener struct {
	ListenerID GraphObjectID `json:"listenerId"`
	ContextID  GraphObjectID `json:"contextId"`
}

// AudioNode protocol object for AudioNode.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#type-AudioNode
type AudioNode struct {
	NodeID                GraphObjectID         `json:"nodeId"`
	ContextID             GraphObjectID         `json:"contextId"`
	NodeType              cdp.NodeType          `json:"nodeType"`
	NumberOfInputs        float64               `json:"numberOfInputs"`
	NumberOfOutputs       float64               `json:"numberOfOutputs"`
	ChannelCount          float64               `json:"channelCount"`
	ChannelCountMode      ChannelCountMode      `json:"channelCountMode"`
	ChannelInterpretation ChannelInterpretation `json:"channelInterpretation"`
}

// AudioParam protocol object for AudioParam.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/WebAudio#type-AudioParam
type AudioParam struct {
	ParamID      GraphObjectID  `json:"paramId"`
	NodeID       GraphObjectID  `json:"nodeId"`
	ContextID    GraphObjectID  `json:"contextId"`
	ParamType    ParamType      `json:"paramType"`
	Rate         AutomationRate `json:"rate"`
	DefaultValue float64        `json:"defaultValue"`
	MinValue     float64        `json:"minValue"`
	MaxValue     float64        `json:"maxValue"`
}
