/*
Textmagic API

No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

API version: 2
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package TextMagic

import (
	"encoding/json"
	"bytes"
	"fmt"
)

// checks if the Invoice type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &Invoice{}

// Invoice struct for Invoice
type Invoice struct {
	// The invoice ID.
	Id int32 `json:"id"`
	// Top-up amount.
	Bundle int32 `json:"bundle"`
	// Top-up currency.
	Currency string `json:"currency"`
	// VAT charged (if any).
	Vat float32 `json:"vat"`
	// Payment method description.
	PaymentMethod NullableString `json:"paymentMethod"`
}

type _Invoice Invoice

// NewInvoice instantiates a new Invoice object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewInvoice(id int32, bundle int32, currency string, vat float32, paymentMethod NullableString) *Invoice {
	this := Invoice{}
	this.Id = id
	this.Bundle = bundle
	this.Currency = currency
	this.Vat = vat
	this.PaymentMethod = paymentMethod
	return &this
}

// NewInvoiceWithDefaults instantiates a new Invoice object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewInvoiceWithDefaults() *Invoice {
	this := Invoice{}
	return &this
}

// GetId returns the Id field value
func (o *Invoice) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *Invoice) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *Invoice) SetId(v int32) {
	o.Id = v
}

// GetBundle returns the Bundle field value
func (o *Invoice) GetBundle() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Bundle
}

// GetBundleOk returns a tuple with the Bundle field value
// and a boolean to check if the value has been set.
func (o *Invoice) GetBundleOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Bundle, true
}

// SetBundle sets field value
func (o *Invoice) SetBundle(v int32) {
	o.Bundle = v
}

// GetCurrency returns the Currency field value
func (o *Invoice) GetCurrency() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Currency
}

// GetCurrencyOk returns a tuple with the Currency field value
// and a boolean to check if the value has been set.
func (o *Invoice) GetCurrencyOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Currency, true
}

// SetCurrency sets field value
func (o *Invoice) SetCurrency(v string) {
	o.Currency = v
}

// GetVat returns the Vat field value
func (o *Invoice) GetVat() float32 {
	if o == nil {
		var ret float32
		return ret
	}

	return o.Vat
}

// GetVatOk returns a tuple with the Vat field value
// and a boolean to check if the value has been set.
func (o *Invoice) GetVatOk() (*float32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Vat, true
}

// SetVat sets field value
func (o *Invoice) SetVat(v float32) {
	o.Vat = v
}

// GetPaymentMethod returns the PaymentMethod field value
// If the value is explicit nil, the zero value for string will be returned
func (o *Invoice) GetPaymentMethod() string {
	if o == nil || o.PaymentMethod.Get() == nil {
		var ret string
		return ret
	}

	return *o.PaymentMethod.Get()
}

// GetPaymentMethodOk returns a tuple with the PaymentMethod field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *Invoice) GetPaymentMethodOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.PaymentMethod.Get(), o.PaymentMethod.IsSet()
}

// SetPaymentMethod sets field value
func (o *Invoice) SetPaymentMethod(v string) {
	o.PaymentMethod.Set(&v)
}

func (o Invoice) MarshalJSON() ([]byte, error) {
	toSerialize,err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o Invoice) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["bundle"] = o.Bundle
	toSerialize["currency"] = o.Currency
	toSerialize["vat"] = o.Vat
	toSerialize["paymentMethod"] = o.PaymentMethod.Get()
	return toSerialize, nil
}

func (o *Invoice) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"bundle",
		"currency",
		"vat",
		"paymentMethod",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err;
	}

	for _, requiredProperty := range(requiredProperties) {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varInvoice := _Invoice{}

	decoder := json.NewDecoder(bytes.NewReader(data))
	decoder.DisallowUnknownFields()
	err = decoder.Decode(&varInvoice)

	if err != nil {
		return err
	}

	*o = Invoice(varInvoice)

	return err
}

type NullableInvoice struct {
	value *Invoice
	isSet bool
}

func (v NullableInvoice) Get() *Invoice {
	return v.value
}

func (v *NullableInvoice) Set(val *Invoice) {
	v.value = val
	v.isSet = true
}

func (v NullableInvoice) IsSet() bool {
	return v.isSet
}

func (v *NullableInvoice) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableInvoice(val *Invoice) *NullableInvoice {
	return &NullableInvoice{value: val, isSet: true}
}

func (v NullableInvoice) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableInvoice) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


