// SPDX-License-Identifier: Apache-2.0
// Copyright 2024 Isovalent Inc.

package metricsmd

import (
	"fmt"
	"log/slog"

	"github.com/prometheus/client_golang/prometheus"
)

type LabelValues struct {
	Label  string
	Values []string
}

type LabelOverrides struct {
	Metric    string
	Overrides []LabelValues
}

type Config struct {
	CobraAnnotations     map[string]string
	Targets              map[string]string // cli argument -> docs header
	LabelOverrides       []LabelOverrides
	InitMetrics          func(target string, reg *prometheus.Registry, log *slog.Logger) error
	AutogeneratedComment bool
	HeadingLevel         int // must be between 0 and 4
}

func validateConfig(config *Config) error {
	if config.Targets == nil {
		return fmt.Errorf("config.Targets must be set")
	}
	if config.InitMetrics == nil {
		return fmt.Errorf("config.InitMetrics must be set")
	}
	if config.HeadingLevel < 0 || config.HeadingLevel > 4 {
		return fmt.Errorf("config.HeadingLevel must be between 0 and 4")
	}
	return nil
}
