/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef LEFTWIDGETITEM_H
#define LEFTWIDGETITEM_H

#include <QWidget>
#include <QLabel>
#include <QHBoxLayout>
#include <QSvgRenderer>
#include <QPixmap>
#include <QResizeEvent>

class LeftWidgetItem : public QWidget
{
    Q_OBJECT

public:
    explicit LeftWidgetItem(QWidget *parent = 0);
    ~LeftWidgetItem();

public:
    void setLabelPixmap(QString filename, QString icoName, QString color);
    void isSetLabelPixmapWhite(bool selected);
    void setLabelText(QString text);
    void setLabelTextIsWhite(bool selected);

    void setSelected(bool selected);

    QString text();

    // Load svg picture
    const QPixmap loadSvg(const QString &fileName, QString color);
    // Chang svg picture's color
    QPixmap drawSymbolicColoredPixmap(const QPixmap &source, QString cgcolor);

protected:
    void resizeEvent(QResizeEvent *event);

private slots:
    void changedLabelSlot();
private:
    QLabel * iconLabel;
    QLabel * textLabel;

    QWidget * widget;
    QString icoName;
    QString mStr;

};

#endif // LEFTWIDGETITEM_H
